package moos.operations.portal.ssds;

import java.util.Date;

import moos.ssds.jms.Publisher;

import org.mbari.isi.interfaces.MetadataPacket;

/**
 * <h2><u>Description</u></h2>
 * <p>For publishing XML Metadata to SSDS </p>
 *
 * <h2><u>UML</u></h2>
 * <pre>
 *
 * </pre>
 *
 * <h2><u>License</u></h2>
 * <p><font size="-1" color="#336699"><a href="http://www.mbari.org">
 * The Monterey Bay Aquarium Research Institute (MBARI)</a> provides this
 * documentation and code &quot;as is&quot;, with no warranty, express or
 * implied, of its quality or consistency. It is provided without support and
 * without obligation on the part of MBARI to assist in its use, correction,
 * modification, or enhancement. This information should not be published or
 * distributed to third parties without specific written permission from
 * MBARI.</font></p>
 *
 * <p><font size="-1" color="#336699">Copyright 2003 MBARI.
 * MBARI Proprietary Information. All rights reserved.</font></p>
 *
 * @author <a href="mailto:brian@mbari.org">Brian Schlining</a>
 * @version $Id: XMLPublisher.java,v 1.2 2003/07/14 23:01:05 brian Exp $
 * @since Jun 5, 2003 10:59:14 AM
 */
public class XMLPublisher {

	/**
	 * 
	 */
	public XMLPublisher(String topic) {
        publisher = new Publisher(topic);
	}

	public void publish() {

		// Put the XML into a byte array
		byte[] xml = xmlFactory.getXMLAsByteArray();

		// Get the device ID that the metadata is associated with
        long id = xmlFactory.getDeviceId();
        
		// Create a DataPacket to store the info in.
        // TODO 20030605 brian - Should I be using MetadataPacket. If so, what is the 'cause'
        
        MetadataPacket mpacket = new MetadataPacket(id, new byte[]{0}, xml);
        mpacket.setSystemTime((new Date()).getTime());
        mpacket.setSequenceNo(0);
               
        publisher.publish(mpacket);

	}
    

	/**
	 * @return
	 * @since Jun 5, 2003
	 */
	public IXMLFactory getXmlFactory() {
		return xmlFactory;
	}

	/**
	 * @param factory
	 * @since Jun 5, 2003
	 */
	public void setXmlFactory(IXMLFactory factory) {
		xmlFactory = factory;
	}

    
    public boolean isConnected() {
        return publisher.isConnected();
    }
    
    /**
     * Factory object is responsible generating XML metadata.
     */
    IXMLFactory xmlFactory;
    
    /**
     * Publisher sends XML to SSDS via JMS
     */
    Publisher publisher;



}
