package moos.operations.portal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;

import moos.operations.portal.auvctd.AUVXMLFactory;
import moos.operations.portal.ssds.XMLPublisher;




/**
 * <h2><u>Description</u></h2>
 * <p><!--Insert summary here--></p>
 *
 * <h2><u>UML</u></h2>
 * <pre>
 *
 * </pre>
 *
 * <h2><u>License</u></h2>
 * <p><font size="-1" color="#336699"><a href="http://www.mbari.org">
 * The Monterey Bay Aquarium Research Institute (MBARI)</a> provides this
 * documentation and code &quot;as is&quot;, with no warranty, express or
 * implied, of its quality or consistency. It is provided without support and
 * without obligation on the part of MBARI to assist in its use, correction,
 * modification, or enhancement. This information should not be published or
 * distributed to third parties without specific written permission from
 * MBARI.</font></p>
 *
 * <p><font size="-1" color="#336699">Copyright 2003 MBARI.
 * MBARI Proprietary Information. All rights reserved.</font></p>
 *
 * @author <a href="mailto:brian@mbari.org">Brian Schlining</a>
 * @version $Id: AUVLoader.java,v 1.6 2003/07/15 23:25:35 brian Exp $
 * @since Jun 12, 2003 2:19:38 PM
 */
public class AUVLoader {

	/**
	 * 
	 */
	public AUVLoader(String archiveRoot) throws IOException {
		this.archiveRoot = new File(archiveRoot);

		filter = new FilenameFilter() {
			public boolean accept(File someDir, String someName) {
				return (someName.equalsIgnoreCase("vehicle.cfg"));
			}
		};

		// Load user specifed properties
        ResourceBundle rb = ResourceBundle.getBundle("auvportal");

		this.httpRoot = rb.getString("remote.url");
		this.httpSSDS = rb.getString("ssds.data.url");

		// Setup communications
		String topic = rb.getString("jms.topic");
		publisher = new XMLPublisher(topic);
		//subscriber = new Subscriber(topic, new DataPacketListener2());

	}

	public void start() throws MalformedURLException, InterruptedException {

		processDir(archiveRoot);

	}

	private void processDir(File dir) throws MalformedURLException, InterruptedException {
		System.out.println("Peeking into " + dir);
		File[] fs = dir.listFiles();
		if (fs != null) {

			for (int i = 0; i < fs.length; i++) {
				if (!fs[i].isHidden() && fs[i].isDirectory()) {
                    
					File[] ls = fs[i].listFiles(filter);
                    
					if (ls.length > 0) {
                        System.out.println("Found " + ls[0]);
						processMission(fs[i]);
					}
					processDir(fs[i]);
				}
			}
		}
		else {
			System.out.println("Nothing found in " + dir);
		}

	}

	private synchronized void processMission(File missionDir) throws MalformedURLException, InterruptedException {
		System.out.print("Processing " + missionDir);
		String md = missionDir.getAbsolutePath();
		int idx = (int) archiveRoot.getAbsolutePath().length();
		URL missionURL = new URL(httpRoot + md.substring(idx));
        System.out.println(" using " + missionURL);
        System.out.println("Calling AUVXMLFactory(" + missionDir.getAbsolutePath() +
            ", " + missionURL + ")");
		AUVXMLFactory factory = new AUVXMLFactory(missionDir, missionURL);
		publisher.setXmlFactory(factory);
        System.out.print("Attempting to publish....");
		publisher.publish();
        System.out.println("published");
	}

	public static void main(String[] args) throws IOException, MalformedURLException, InterruptedException {
		AUVLoader loader = new AUVLoader(args[0]);
		loader.start();

	}

	private final FilenameFilter filter;

	XMLPublisher publisher;
	//Subscriber subscriber;
	/**
	 * i.e /mbari/auvctd or perhaps /tornado/vol/vol1/AUVCTD
	 */

	File archiveRoot;

	/**
	 * i.e http://prey.shore.mbari.org/auvctd (web mount point for /tornao/vol/vol1/AUVCTD
	 */
	String httpRoot;

	String httpSSDS;
}
