package example;
/**
 * <p>Example for marshalling XML from the SSDS object model</p><hr>
 * @author  : $Author: brian $
 * @version : $Revision: 1.2 $
 *
 * <hr><p><font size="-1" color="#336699"><a href="http://www.mbari.org">
 * The Monterey Bay Aquarium Research Institute (MBARI)</a> provides this
 * documentation and code &quot;as is&quot;, with no warranty, express or
 * implied, of its quality or consistency. It is provided without support and
 * without obligation on the part of MBARI to assist in its use, correction,
 * modification, or enhancement. This information should not be published or
 * distributed to third parties without specific written permission from MBARI.</font></p><br>
 * <font size="-1" color="#336699">Copyright 2002 MBARI.<br>
 * MBARI Proprietary Information. All rights reserved.</font><br><hr><br>
 */

import java.net.URL;

import moos.ssds.model.ObjectBuilder;
import moos.ssds.model.XmlBuilder;

public class Test1 {
    public Test1(String in, String out) throws Exception {

        // Generate Objects from XML
        ObjectBuilder mb = new ObjectBuilder(new URL("file:" + in));
        mb.unmarshal();

        // Generate XML from the Objects
        XmlBuilder xb = new XmlBuilder();
        xb.addAll(mb.listAll());
        xb.marshal();

        // Print to the Screen
        xb.print();

        // Write to a file
        xb.toFile(new java.io.File(out));

    }

    public static void main(String[] args) {
        try {
            Test1 test11 = new Test1(args[0], args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

}
