package example;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import moos.ssds.jms.Publisher;
import moos.ssds.model.DataPacket;
import moos.ssds.model.Deployment;
import moos.ssds.model.XmlBuilder;

/**
 * <p>Generates a mock-up xml description for an AUV deployment</p><hr>
 * @author  : $Author: brian $
 * @version : $Revision: 1.4 $
 *
 * <hr><p><font size="-1" color="#336699"><a href="http://www.mbari.org">
 * The Monterey Bay Aquarium Research Institute (MBARI)</a> provides this
 * documentation and code &quot;as is&quot;, with no warranty, express or
 * implied, of its quality or consistency. It is provided without support and
 * without obligation on the part of MBARI to assist in its use, correction,
 * modification, or enhancement. This information should not be published or
 * distributed to third parties without specific written permission from MBARI.</font></p><br>
 * <font size="-1" color="#336699">Copyright 2002 MBARI.<br>
 * MBARI Proprietary Information. All rights reserved.</font><br><hr><br>
 */
public class AUVPortal {

	public AUVPortal(File dir) throws MalformedURLException {
		this(dir, dir.toURL());
	}

	public AUVPortal(File dir, URL url) throws MalformedURLException {

		XMLMockup xmlMockup = new XMLMockup(dir, url);
		xmlBuilder = xmlMockup.getXmlBuilder();

	}

	public void contactSSDS() throws IOException {

		// Put the XML into a byte array
		xmlBuilder.marshal();
		ByteArrayOutputStream buf = new ByteArrayOutputStream();
        xmlBuilder.print();
		xmlBuilder.print(buf);
        
        // Get platformID
        Collection rootElements = xmlBuilder.getRootElements();
        Iterator iterator = rootElements.iterator();
        Deployment deployment = (Deployment) iterator.next();
        long id = deployment.getDevice().getId().longValue();
        
        

		//      Create a DataPacket to store the info in.
		DataPacket packet = new DataPacket(0, buf.size());
		packet.setSequenceNo(0);
		packet.setMetadataId(0);
		packet.setPlatformId(id);
		packet.setRecordType(0);
		packet.setSystemTime((new Date()).getTime());
		packet.setDataBuffer(buf.toByteArray());

		// Send to SSDS
		publisher.publish(packet);

	}

	public static void main(String[] args) {
		try {
			AUVPortal portal;
            if (args.length == 1) {
            
                portal = new AUVPortal(new File(args[0]));
            }
            else {
                portal = new AUVPortal(new File(args[0]), new URL(args[1]));
            }
			portal.contactSSDS();
		}
		catch (Exception e) {
			System.out.println("Usage: java example.AUVPortal missionDirectory webRoot");
		}

	}

	XmlBuilder xmlBuilder;
	Publisher publisher = new Publisher("topic/testTopic");

}
