/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.isi.interfaces;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.mbari.isi.interfaces.LayeredDebug;
import org.mbari.isi.interfaces.ScheduleParseException;

public class ScheduleSpecifier
implements Serializable {
    public static final long DEBUG_ALL = 32768L;
    public static final long DEBUG_MAIN = 16384L;
    public static final int MIN_LENGTH = 19;
    public static final int MAX_DAY_OF_YEAR = 365;
    public static final int MIN_DAY_OF_YEAR = 0;
    public static final int MAX_MONTH = 11;
    public static final int MIN_MONTH = 0;
    public static final int MAX_DAY_OF_MONTH = 31;
    public static final int MIN_DAY_OF_MONTH = 1;
    public static final int MAX_DAY_OF_WEEK = 7;
    public static final int MIN_DAY_OF_WEEK = 1;
    public static final int MAX_HOUR = 23;
    public static final int MIN_HOUR = 0;
    public static final int MAX_MINUTE = 59;
    public static final int MIN_MINUTE = 0;
    public static final int MAX_SECOND = 59;
    public static final int MIN_SECOND = 0;
    public static final long MS_PER_SECOND = 1000L;
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;
    public static final long S_PER_DAY = 86400L;
    public static final int SCHEDULE_TYPE = 0;
    public static final int SECONDS = 1;
    public static final int MINUTES = 2;
    public static final int HOURS = 3;
    public static final int DAYS = 4;
    public static final int MONTHS = 5;
    public static final int DAYS_OF_WEEK = 6;
    public static final int DAYS_OF_MONTH = 7;
    public static final int DAYS_OF_YEAR = 8;
    public static final int TIME_ZONE = 9;
    public static final int CYCLES = 10;
    public static final int JOB = 11;
    public static final int DISPLAY_NAME = 12;
    public static final int MAX_FIELD = 13;
    public static final int SCHEDULE_TIME = 14;
    public static final String[] _dayNames = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    public static final String[] _monthNames = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    String _line = null;
    String _scheduleType = null;
    boolean _bRelative;
    boolean _bAbsolute;
    String _months = null;
    boolean[] _bMonths = new boolean[12];
    String _daysOfMonth = null;
    boolean[] _bDaysOfMonth = new boolean[31];
    String _daysOfYear = null;
    boolean[] _bDaysOfYear = new boolean[366];
    String _daysOfWeek = null;
    boolean[] _bDaysOfWeek = new boolean[7];
    String _days = null;
    long _lDays = 0L;
    String _hours = null;
    long _lHours = 0L;
    boolean[] _bHours = new boolean[24];
    String _minutes = null;
    long _lMinutes = 0L;
    boolean[] _bMinutes = new boolean[60];
    String _seconds = null;
    long _lSeconds = 0L;
    boolean[] _bSeconds = new boolean[60];
    String _cycles = null;
    long _longCycles = -1L;
    String _timeZone = null;
    TimeZone _tzTimeZone = null;
    long _period = 0L;
    String _job = null;
    String _displayName = null;

    public ScheduleSpecifier() {
    }

    public ScheduleSpecifier(String spec) throws ScheduleParseException {
        if (spec.length() > 0) {
            ScheduleSpecifier.parse(this, spec);
        }
        this.setLine(this.toString());
    }

    public ScheduleSpecifier(long period) throws ScheduleParseException {
        if (period < 1000L) {
            throw new ScheduleParseException("Invalid Period");
        }
        long days = period / 86400000L;
        long hours = (period -= days * 86400000L) / 3600000L;
        long minutes = (period -= hours * 3600000L) / 60000L;
        long seconds = (period -= minutes * 60000L) / 1000L;
        period -= seconds * 1000L;
        this.setScheduleType("R");
        this.setSeconds("*/" + seconds);
        this.setMinutes("*/" + minutes);
        this.setHours("*/" + hours);
        this.setDays("*/" + days);
        this.setMonths("*");
        this.setDaysOfWeek("*");
        this.setDaysOfMonth("*");
        this.setDaysOfYear("*");
        this.setCycles("*");
        this.setTimeZone("GMT");
        this.setLine(this.toString());
    }

    public String getFieldName(int position) {
        switch (position) {
            case 0: {
                return "Schedule Type";
            }
            case 1: {
                return "Seconds";
            }
            case 2: {
                return "Minutes";
            }
            case 3: {
                return "Hours";
            }
            case 4: {
                return "Days";
            }
            case 5: {
                return "Month";
            }
            case 6: {
                return "Days of Week";
            }
            case 7: {
                return "Days of Month";
            }
            case 8: {
                return "Days of Year";
            }
            case 10: {
                return "Cycles";
            }
            case 9: {
                return "Time Zone";
            }
            case 11: {
                return "Job Name";
            }
        }
        return "Undefined Field";
    }

    public String getScheduleType() {
        return this._scheduleType;
    }

    public void setScheduleType(String type) throws ScheduleParseException {
        type.trim();
        type = type.substring(0, 1).toUpperCase();
        if (!type.equals("R") && !type.equals("A")) {
            throw new ScheduleParseException("Invalid schedule type (" + type + ")");
        }
        this._scheduleType = type;
        this.setBScheduleType(type);
        LayeredDebug.println(32768L, "ScheduleType = " + this.getScheduleType());
    }

    public void setBScheduleType(String type) {
        if (type.substring(0, 1).toUpperCase().equals("R")) {
            this._bRelative = true;
            this._bAbsolute = false;
        }
        if (type.substring(0, 1).toUpperCase().equals("A")) {
            this._bRelative = false;
            this._bAbsolute = true;
        }
    }

    public boolean isRelative() {
        return this._bRelative;
    }

    public void setBRelative(boolean bRelative) {
        this._bRelative = bRelative;
    }

    public boolean isAbsolute() {
        return this._bAbsolute;
    }

    public void setBAbsolute(boolean bAbsolute) {
        this._bAbsolute = bAbsolute;
    }

    public boolean[] getBMonths() {
        return this._bMonths;
    }

    public void setBMonths(boolean[] months) {
        this._bMonths = months;
    }

    public boolean[] getBDaysOfMonth() {
        return this._bDaysOfMonth;
    }

    public void setBDaysOfMonth(boolean[] daysOfMonth) {
        this._bDaysOfMonth = daysOfMonth;
    }

    public boolean[] getBDaysOfYear() {
        return this._bDaysOfYear;
    }

    public void setBDaysOfYear(boolean[] daysOfYear) {
        this._bDaysOfYear = daysOfYear;
    }

    public boolean[] getBDaysOfWeek() {
        return this._bDaysOfWeek;
    }

    public void setBDaysOfWeek(boolean[] daysOfWeek) {
        this._bDaysOfWeek = daysOfWeek;
    }

    public boolean[] getBHours() {
        return this._bHours;
    }

    public void setBHours(boolean[] hours) {
        this._bHours = hours;
    }

    public boolean[] getBMinutes() {
        return this._bMinutes;
    }

    public void setBMinutes(boolean[] minutes) {
        this._bMinutes = minutes;
    }

    public boolean[] getBSeconds() {
        return this._bSeconds;
    }

    public void setBSeconds(boolean[] seconds) {
        this._bSeconds = seconds;
    }

    public long getLongCycles() {
        return this._longCycles;
    }

    public void setLongCycles(long cycles) {
        this._longCycles = cycles;
    }

    public String getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(String timeZone) throws ScheduleParseException {
        this.validateTimezone(timeZone);
        this._tzTimeZone = TimeZone.getTimeZone(timeZone);
        this._timeZone = timeZone;
    }

    public TimeZone getTZ() {
        return this._tzTimeZone;
    }

    public String getMonths() {
        return this._months;
    }

    public void setMonths(String months) throws ScheduleParseException {
        months.trim();
        FieldSpec fieldSpec = this.parseToken(months, this._bMonths.length - 1);
        this.setBMonths(this.processToken(fieldSpec, this._bMonths));
        this._months = months;
    }

    public String getDays() {
        return this._days;
    }

    public void setDays(String days) throws ScheduleParseException {
        days.trim();
        FieldSpec fieldSpec = this.parseToken(days, 0L);
        this._lDays = fieldSpec.getModulus();
        this._days = days;
        this.computePeriod();
    }

    public String getDaysOfYear() {
        return this._daysOfYear;
    }

    public void setDaysOfYear(String daysOfYear) throws ScheduleParseException {
        daysOfYear.trim();
        FieldSpec fieldSpec = this.parseToken(daysOfYear, this._bDaysOfYear.length - 1);
        this.setBDaysOfYear(this.processToken(fieldSpec, this._bDaysOfYear));
        this._daysOfYear = daysOfYear;
    }

    public String getDaysOfMonth() {
        return this._daysOfMonth;
    }

    public void setDaysOfMonth(String daysOfMonth) throws ScheduleParseException {
        daysOfMonth.trim();
        FieldSpec fieldSpec = this.parseToken(daysOfMonth, this._bDaysOfMonth.length - 1);
        this.setBDaysOfMonth(this.processToken(fieldSpec, this._bDaysOfMonth));
        this._daysOfMonth = daysOfMonth;
    }

    public String getDaysOfWeek() {
        return this._daysOfWeek;
    }

    public void setDaysOfWeek(String daysOfWeek) throws ScheduleParseException {
        daysOfWeek.trim();
        FieldSpec fieldSpec = this.parseToken(daysOfWeek, this._bDaysOfWeek.length - 1);
        this.setBDaysOfWeek(this.processToken(fieldSpec, this._bDaysOfWeek));
        this._daysOfWeek = daysOfWeek;
    }

    public String getHours() {
        return this._hours;
    }

    public void setHours(String hours) throws ScheduleParseException {
        hours.trim();
        FieldSpec fieldSpec = this.parseToken(hours, this._bHours.length - 1);
        this.setBHours(this.processToken(fieldSpec, this._bHours));
        this._lHours = fieldSpec.getModulus();
        this._hours = hours;
        this.computePeriod();
    }

    public String getMinutes() {
        return this._minutes;
    }

    public void setMinutes(String minutes) throws ScheduleParseException {
        minutes.trim();
        FieldSpec fieldSpec = this.parseToken(minutes, this._bMinutes.length - 1);
        this.setBMinutes(this.processToken(fieldSpec, this._bMinutes));
        this._lMinutes = fieldSpec.getModulus();
        this._minutes = minutes;
    }

    public String getSeconds() {
        return this._seconds;
    }

    public void setSeconds(String seconds) throws ScheduleParseException {
        seconds.trim();
        FieldSpec fieldSpec = this.parseToken(seconds, this._bSeconds.length - 1);
        this.setBSeconds(this.processToken(fieldSpec, this._bSeconds));
        this._lSeconds = fieldSpec.getModulus();
        this._seconds = seconds;
        this.computePeriod();
    }

    public String getCycles() {
        return this._cycles;
    }

    public void setCycles(String cycles) throws ScheduleParseException {
        try {
            if (cycles.trim().equals("*")) {
                this.setLongCycles(-1L);
            } else {
                this.setLongCycles(Long.parseLong(cycles.trim()));
            }
            this._cycles = cycles;
        }
        catch (NumberFormatException e) {
            throw new ScheduleParseException("Invalid Cycles specifier: " + cycles + " \n" + e.toString());
        }
    }

    public long getPeriod() {
        return this._period;
    }

    public String getJob() {
        return this._job;
    }

    public void setJob(String job) {
        this._job = job;
    }

    public String getDisplayName() {
        if (this._displayName == null || this._displayName.length() == 0) {
            return this._job;
        }
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName.trim();
    }

    public String getLine() {
        return this._line;
    }

    public void setLine(String line) {
        this._line = line;
    }

    public String getScheduleTime() {
        String spec = "";
        if (this._scheduleType != null) {
            spec = spec + this._scheduleType;
        }
        if (this._seconds != null) {
            spec = spec + " " + this._seconds;
        }
        if (this._minutes != null) {
            spec = spec + " " + this._minutes;
        }
        if (this._hours != null) {
            spec = spec + " " + this._hours;
        }
        if (this._days != null) {
            spec = spec + " " + this._days;
        }
        if (this._months != null) {
            spec = spec + " " + this._months;
        }
        if (this._daysOfWeek != null) {
            spec = spec + " " + this._daysOfWeek;
        }
        if (this._daysOfMonth != null) {
            spec = spec + " " + this._daysOfMonth;
        }
        if (this._daysOfYear != null) {
            spec = spec + " " + this._daysOfYear;
        }
        if (this._timeZone != null) {
            spec = spec + " " + this._timeZone;
        }
        if (this._cycles != null) {
            spec = spec + " " + this._cycles;
        }
        return spec;
    }

    public static void parse(ScheduleSpecifier thisOne, String line) throws ScheduleParseException {
        line.trim();
        StringTokenizer lt = new StringTokenizer(line, "#");
        if (lt.hasMoreTokens()) {
            line = lt.nextToken();
        }
        LayeredDebug.println(32768L, "parsing line " + line);
        lt = new StringTokenizer(line, " \t\r\f\n");
        int field = 0;
        while (lt.hasMoreTokens()) {
            String fieldToken = lt.nextToken();
            fieldToken.trim();
            LayeredDebug.println(32768L, "parsing field " + fieldToken);
            thisOne.set(field, fieldToken);
            ++field;
        }
        try {
            String dn = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\"") - 1);
            thisOne.set(12, dn);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (thisOne.getJob() != null) {
                thisOne.set(12, thisOne.getJob());
            } else {
                thisOne.set(12, "unspecified");
            }
        }
        catch (NullPointerException n) {
            if (thisOne.getJob() != null) {
                thisOne.set(12, thisOne.getJob());
            }
            thisOne.set(12, "unspecified");
        }
        thisOne.setLine(thisOne.toString());
    }

    public String get(int field) {
        switch (field) {
            case 0: {
                return this.getScheduleType();
            }
            case 8: {
                return this.getDaysOfYear();
            }
            case 7: {
                return this.getDaysOfMonth();
            }
            case 6: {
                return this.getDaysOfWeek();
            }
            case 5: {
                return this.getMonths();
            }
            case 4: {
                return this.getDays();
            }
            case 3: {
                return this.getHours();
            }
            case 2: {
                return this.getMinutes();
            }
            case 1: {
                return this.getSeconds();
            }
            case 10: {
                return this.getCycles();
            }
            case 9: {
                return this.getTimeZone();
            }
            case 11: {
                return this.getJob();
            }
            case 12: {
                return this.getDisplayName();
            }
            case 14: {
                return this.getScheduleTime();
            }
        }
        return null;
    }

    public void set(int field, String spec) throws ScheduleParseException {
        switch (field) {
            case 0: {
                this.setScheduleType(spec);
                break;
            }
            case 8: {
                this.setDaysOfYear(spec);
                break;
            }
            case 7: {
                this.setDaysOfMonth(spec);
                break;
            }
            case 6: {
                this.setDaysOfWeek(spec);
                break;
            }
            case 5: {
                this.setMonths(spec);
                break;
            }
            case 4: {
                this.setDays(spec);
                break;
            }
            case 3: {
                this.setHours(spec);
                break;
            }
            case 2: {
                this.setMinutes(spec);
                break;
            }
            case 1: {
                this.setSeconds(spec);
                break;
            }
            case 10: {
                this.setCycles(spec);
                break;
            }
            case 9: {
                this.setTimeZone(spec);
                break;
            }
            case 11: {
                this.setJob(spec);
                break;
            }
            case 12: {
                this.setDisplayName(spec);
            }
        }
    }

    protected FieldSpec parseToken(String token, long maxRange) throws ScheduleParseException {
        long modulus = 0L;
        long firstElement = 0L;
        long lastElement = 0L;
        FieldSpec fieldSpec = new FieldSpec();
        boolean i = false;
        LayeredDebug.println(32768L, "parsing token " + token);
        token.trim();
        StringTokenizer tt = new StringTokenizer(token, ",");
        String fieldToken = null;
        while (tt.hasMoreTokens()) {
            StringTokenizer rt;
            fieldToken = tt.nextToken();
            LayeredDebug.println(32768L, "parsing token field " + fieldToken);
            StringTokenizer mt = new StringTokenizer(fieldToken, "/");
            if (mt.countTokens() > 1) {
                modulus = this.longIndex(fieldToken.substring(fieldToken.indexOf("/") + 1));
                LayeredDebug.println(32768L, "parsing token modulus " + modulus);
                fieldToken = mt.nextToken();
                LayeredDebug.println(32768L, "trimming modulus from token " + fieldToken);
            }
            if ((rt = new StringTokenizer(fieldToken, "-")).countTokens() > 1) {
                LayeredDebug.println(32768L, "parsing range " + rt.countTokens());
                String tempString = rt.nextToken();
                firstElement = this.getLongIndex(tempString);
                lastElement = this.getLongIndex(fieldToken.substring(fieldToken.indexOf("-") + 1));
            } else {
                LayeredDebug.println(32768L, "parsing non-range token " + fieldToken);
                boolean parseDone = false;
                long test = -1L;
                if (fieldToken.equals("*")) {
                    LayeredDebug.println(32768L, "parsing * ");
                    firstElement = 0L;
                    lastElement = maxRange;
                    parseDone = true;
                }
                if (!parseDone) {
                    LayeredDebug.println(32768L, "parsing name or number ");
                    test = this.getLongIndex(fieldToken);
                    if (test >= 0L) {
                        firstElement = lastElement = test;
                        parseDone = true;
                    }
                }
                if (!parseDone) {
                    System.err.println("uh oh Davy, couldn't parse it ");
                    throw new ScheduleParseException("parse(): invalid Schedule Entry (" + fieldToken + ")");
                }
            }
            LayeredDebug.println(32768L, "first,last elements: " + firstElement + "," + lastElement);
            LayeredDebug.println(32768L, "Range checking...");
            if (firstElement < 0L || firstElement > maxRange) {
                throw new ScheduleParseException("RangeException in parse(): invalid firstElement");
            }
            if (lastElement < 0L || lastElement > maxRange) {
                throw new ScheduleParseException("RangeException in parse(): invalid lastElement " + lastElement + " " + maxRange);
            }
            if (modulus < 0L) {
                throw new ScheduleParseException("RangeException in parse(): invalid modulus");
            }
            fieldSpec.setModulus(modulus);
            fieldSpec.addRange(new Range(firstElement, lastElement));
            LayeredDebug.println(32768L, " ");
        }
        LayeredDebug.println(32768L, " ");
        return fieldSpec;
    }

    public boolean[] processToken(FieldSpec fieldSpec, boolean[] barray) {
        LayeredDebug.println(32768L, "Processing token...");
        if (barray == null) {
            return null;
        }
        Vector ranges = fieldSpec.getRanges();
        long modulus = fieldSpec.getModulus();
        long fillModulus = 1L;
        if (this.isAbsolute() && modulus > 1L) {
            fillModulus = modulus;
        }
        Enumeration e = ranges.elements();
        while (e.hasMoreElements()) {
            Range r = (Range)e.nextElement();
            int firstElement = (int)r.getStart();
            int lastElement = (int)r.getEnd();
            LayeredDebug.println(32768L, "(filling array) " + firstElement + " " + lastElement + " " + modulus);
            int modCount = 0;
            int pels = 1;
            int i = firstElement;
            while (i != lastElement) {
                if ((long)modCount++ % fillModulus == 0L) {
                    barray[i] = true;
                    LayeredDebug.print(32768L, " [" + i + "]");
                    if (++pels % 15 == 0) {
                        LayeredDebug.println(32768L, " ");
                    }
                } else {
                    barray[i] = false;
                }
                if (i == barray.length - 1) {
                    i = -1;
                }
                ++i;
            }
            if (i == lastElement && (long)modCount++ % fillModulus == 0L) {
                barray[i] = true;
                LayeredDebug.print(32768L, " [" + i + "]");
                if (++pels % 15 == 0) {
                    LayeredDebug.println(32768L, " ");
                }
            }
            LayeredDebug.println(32768L, " ");
        }
        return barray;
    }

    public void validateTimezone(String timezone) throws ScheduleParseException {
        StringTokenizer tzt = new StringTokenizer(timezone, ":");
        try {
            String tokenString = tzt.nextToken();
            if (!tokenString.toUpperCase().startsWith("GMT")) {
                throw new ScheduleParseException("Invalid TimeZone Syntax (GMT[+|-hh[:mm]])");
            }
            if (tokenString.length() > 3) {
                int hhStart = tokenString.toUpperCase().indexOf("GMT") + 4;
                int hh = Integer.parseInt(tokenString.substring(hhStart));
                if (hh < -24 || hh > 24 || tokenString.substring(hhStart).length() > 2) {
                    throw new ScheduleParseException("Invalid TimeZone (Invalid hours)");
                }
                int mm = 0;
                tokenString = "";
                if (tzt.hasMoreTokens()) {
                    tokenString = tzt.nextToken();
                    mm = Integer.parseInt(tokenString);
                }
                if (mm < 0 || mm > 59 || tokenString.length() > 2) {
                    throw new ScheduleParseException("Invalid TimeZone (Invalid minutes)");
                }
            }
        }
        catch (NumberFormatException e) {
            throw new ScheduleParseException("Invalid TimeZone Invalid Number Format");
        }
        catch (NoSuchElementException e2) {
            throw new ScheduleParseException("Invalid TimeZone Syntax (GMT[+|-hh[:mm]])");
        }
        catch (IndexOutOfBoundsException e3) {
            throw new ScheduleParseException("Invalid TimeZone Invalid Index (GMT[+|-hh[:mm]])");
        }
    }

    protected long getLongIndex(String token) {
        long test = this.longIndex(token);
        if (test >= 0L) {
            return test;
        }
        test = this.dayIndex(token);
        if (test >= 0L) {
            return test;
        }
        test = this.monthIndex(token);
        if (test >= 0L) {
            return test;
        }
        return -1L;
    }

    protected int numberIndex(String token) {
        try {
            int number = Integer.parseInt(token);
            if (number < 0) {
                return -1;
            }
            return number;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected long longIndex(String token) {
        try {
            long number = Long.parseLong(token);
            if (number < 0L) {
                return -1L;
            }
            return number;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    protected int dayIndex(String name) {
        int i = 0;
        while (i < 7) {
            if (name.toLowerCase().equals(_dayNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int monthIndex(String name) {
        int i = 0;
        while (i < 11) {
            if (name.toLowerCase().equals(_monthNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        String spec = "";
        if (this._scheduleType != null) {
            spec = spec + " " + this._scheduleType;
        }
        if (this._seconds != null) {
            spec = spec + " " + this._seconds;
        }
        if (this._minutes != null) {
            spec = spec + " " + this._minutes;
        }
        if (this._hours != null) {
            spec = spec + " " + this._hours;
        }
        if (this._days != null) {
            spec = spec + " " + this._days;
        }
        if (this._months != null) {
            spec = spec + " " + this._months;
        }
        if (this._daysOfWeek != null) {
            spec = spec + " " + this._daysOfWeek;
        }
        if (this._daysOfMonth != null) {
            spec = spec + " " + this._daysOfMonth;
        }
        if (this._daysOfYear != null) {
            spec = spec + " " + this._daysOfYear;
        }
        if (this._timeZone != null) {
            spec = spec + " " + this._timeZone;
        }
        if (this._cycles != null) {
            spec = spec + " " + this._cycles;
        }
        if (this._displayName != null) {
            spec = spec + " \"" + this._displayName + "\"";
        }
        if (this._job != null) {
            spec = spec + " (" + this._job + ")";
        }
        return spec.trim();
    }

    public boolean equals(ScheduleSpecifier schedule) {
        if (!this.get(0).equals(schedule.get(0))) {
            return false;
        }
        if (!this.get(1).equals(schedule.get(1))) {
            return false;
        }
        if (!this.get(2).equals(schedule.get(2))) {
            return false;
        }
        if (!this.get(3).equals(schedule.get(3))) {
            return false;
        }
        if (!this.get(4).equals(schedule.get(4))) {
            return false;
        }
        if (!this.get(5).equals(schedule.get(5))) {
            return false;
        }
        if (!this.get(6).equals(schedule.get(6))) {
            return false;
        }
        if (!this.get(7).equals(schedule.get(7))) {
            return false;
        }
        if (!this.get(8).equals(schedule.get(8))) {
            return false;
        }
        if (!this.get(9).equals(schedule.get(9))) {
            return false;
        }
        if (!this.get(10).equals(schedule.get(10))) {
            return false;
        }
        return this.get(11).equals(schedule.get(11));
    }

    public boolean isSelectedTime(Calendar calendar) {
        try {
            if (!this._bDaysOfYear[calendar.get(6) - 1]) {
                return false;
            }
            if (!this._bDaysOfMonth[calendar.get(5) - 1]) {
                return false;
            }
            if (!this._bDaysOfWeek[calendar.get(7) - 1]) {
                return false;
            }
            if (!this._bMonths[calendar.get(2)]) {
                return false;
            }
            if (!this._bHours[calendar.get(11)]) {
                return false;
            }
            if (!this._bMinutes[calendar.get(12)]) {
                return false;
            }
            if (!this._bSeconds[calendar.get(13)]) {
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("isSelectedTime(): Invalid calendar " + e + " doy " + calendar.get(6) + " dom " + calendar.get(5) + " dow " + calendar.get(7) + " mon " + calendar.get(2) + " hr " + calendar.get(11) + " min " + calendar.get(12) + " sec " + calendar.get(13));
            return false;
        }
        return true;
    }

    public void computePeriod() {
        this._period = 0L;
        this._period += this._lSeconds * 1000L;
        this._period += this._lMinutes * 60000L;
        this._period += this._lHours * 3600000L;
        this._period += this._lDays * 86400000L;
    }

    public static void main(String[] args) {
        long fooMask = 0L;
        if (args.length > 0 && args[0].trim().toLowerCase().startsWith("--h")) {
            System.out.println("\nUsage: java ScheduleSpecifier [period] [debugLevel]\n");
            System.exit(0);
        }
        if (args.length > 1) {
            fooMask = Long.parseLong(args[1]);
        }
        long newMask = 0x4000L | fooMask;
        long oldMask = LayeredDebug.addMask(newMask);
        try {
            long period = 1000L;
            if (args.length > 0) {
                period = Long.parseLong(args[0]);
            }
            ScheduleSpecifier ssp = new ScheduleSpecifier(period);
            LayeredDebug.println(16384L, "ssp:\n" + ssp);
            ScheduleSpecifier sse = new ScheduleSpecifier();
            LayeredDebug.println(16384L, "sse\n" + sse);
            String quux = ssp.toString() + " foo.job";
            ScheduleSpecifier ssg = new ScheduleSpecifier(quux);
            LayeredDebug.println(16384L, "ssg\n" + ssg);
        }
        catch (ScheduleParseException e) {
            System.err.println(e);
        }
        LayeredDebug.setMask(oldMask);
    }

    protected class FieldSpec {
        Vector _ranges = new Vector(10);
        long _modulus;

        protected FieldSpec() {
        }

        public void addRange(Range range) {
            this._ranges.add(range);
        }

        public void setModulus(long modulus) {
            this._modulus = modulus;
        }

        public long getModulus() {
            return this._modulus;
        }

        public Vector getRanges() {
            return this._ranges;
        }

        public void clear() {
            this._ranges.removeAllElements();
            this._ranges.setSize(10);
            this._modulus = 0L;
        }
    }

    protected class Range {
        long _start;
        long _end;

        public Range() {
        }

        public Range(long start, long end) {
            this._start = start;
            this._end = end;
        }

        public long getStart() {
            return this._start;
        }

        public void setStart(long start) {
            this._start = start;
        }

        public long getEnd() {
            return this._end;
        }

        public void setEnd(long end) {
            this._end = end;
        }
    }
}

