/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.isi.interfaces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class RemoteSerialPort
implements Serializable {
    boolean _connected = false;
    int _serverPort;
    InetAddress _serverAddress;
    transient Socket _socket;
    transient BufferedReader _in;
    transient PrintWriter _out;

    public RemoteSerialPort(InetAddress serverAddress, int serverPort) {
        this._serverAddress = serverAddress;
        this._serverPort = serverPort;
    }

    public void connect() throws UnknownHostException, IOException {
        if (this._connected) {
            return;
        }
        this._socket = new Socket(this._serverAddress, this._serverPort);
        this._in = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
        this._out = new PrintWriter(this._socket.getOutputStream(), true);
        this._connected = true;
    }

    public void write(char output) throws IOException {
        this.connect();
        this._out.print(output);
        this._out.flush();
    }

    public int read() throws IOException {
        this.connect();
        return this._in.read();
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public InetAddress getServerInetAddress() {
        return this._serverAddress;
    }
}

