/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.isi.interfaces;

import java.io.Serializable;
import org.mbari.isi.interfaces.DeviceNotFound;

public class Port
implements Serializable {
    protected byte[] _portName = null;
    protected byte[] _serviceMnem = null;
    protected long _deviceID = 0L;
    protected boolean _hasService = false;
    protected boolean _hasPowerSwitch = false;

    public Port(byte[] portName, long deviceID, byte[] serviceMnem) {
        this._portName = new byte[portName.length];
        System.arraycopy(portName, 0, this._portName, 0, portName.length);
        this._deviceID = deviceID;
        this._serviceMnem = new byte[serviceMnem.length];
        System.arraycopy(serviceMnem, 0, this._serviceMnem, 0, serviceMnem.length);
        this._hasService = true;
    }

    public Port(byte[] portName) {
        this._portName = new byte[portName.length];
        System.arraycopy(portName, 0, this._portName, 0, portName.length);
        this._hasService = false;
    }

    public byte[] getName() {
        return this._portName;
    }

    public long getDeviceID() throws DeviceNotFound {
        if (!this._hasService) {
            throw new DeviceNotFound();
        }
        return this._deviceID;
    }

    public byte[] getServiceMnemonic() throws DeviceNotFound {
        if (!this._hasService) {
            throw new DeviceNotFound();
        }
        return this._serviceMnem;
    }

    public boolean hasService() {
        return this._hasService;
    }

    public boolean hasPowerSwitch() {
        return this._hasPowerSwitch;
    }
}

