/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.isi.interfaces;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import org.mbari.isi.interfaces.DevicePacket;

public class DevicePacketStream
implements Serializable {
    transient ObjectInputStream _inputStream;
    boolean _connected = false;
    InetAddress _serverHost;
    int _serverPort;

    public DevicePacketStream(InetAddress serverHost, int serverPort) {
        this._serverHost = serverHost;
        this._serverPort = serverPort;
    }

    public DevicePacket read() throws IOException, ClassNotFoundException {
        if (!this._connected) {
            this._inputStream = this.createInputStream();
            System.out.println("DevicePacket.read() - connected");
            this._connected = true;
        }
        return (DevicePacket)this._inputStream.readObject();
    }

    protected ObjectInputStream createInputStream() throws IOException {
        System.out.println("Creating input stream...");
        System.out.println("Server host: " + this._serverHost.getHostAddress());
        System.out.println("Server port: " + this._serverPort);
        Socket socket = new Socket(this._serverHost, this._serverPort);
        System.out.println("Created socket to server...");
        return new ObjectInputStream(socket.getInputStream());
    }
}

