/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.isi.interfaces;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.InitializeException;
import org.mbari.isi.interfaces.Location;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.NoChildrenException;
import org.mbari.isi.interfaces.NoParentException;
import org.mbari.isi.interfaces.UnknownLocationException;

public interface Device
extends Remote {
    public static final int INSTRUMENT_STATE = 1;
    public static final int SERVICE_XML = 2;
    public static final int SERVICE_STATE = 4;
    public static final int SERVICE_PROPERTIES = 8;
    public static final int SERVICE_CACHE = 16;
    public static final int MDATA_ALL = 31;
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int INITIAL = 2;
    public static final int SHUTDOWN = 3;
    public static final int SUSPEND = 4;
    public static final int SAMPLING = 5;
    public static final int UNKNOWN = -1;
    public static final int POWER_NEVER = 0;
    public static final int POWER_WHEN_SAMPLING = 1;
    public static final int POWER_ALWAYS = 2;

    public byte[] getName() throws RemoteException;

    public long getId() throws RemoteException;

    public void initialize() throws RemoteException, InitializeException;

    public int powerOff() throws RemoteException;

    public int powerOn() throws RemoteException;

    public int getStatus() throws RemoteException;

    public int test() throws RemoteException;

    public Device getParent() throws NoParentException, RemoteException;

    public Device[] getChildren() throws NoChildrenException, RemoteException;

    public InetAddress host() throws RemoteException, UnknownHostException;

    public Location getLocation() throws RemoteException, UnknownLocationException;

    public byte[] getMetadata() throws RemoteException;

    public MetadataPacket createMetadataPacket(String var1, int var2, boolean var3) throws RemoteException;

    public byte[] getCommPortName() throws RemoteException;

    public void suspend() throws RemoteException;

    public void resume() throws RemoteException;
}

