/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.security.SecureRandom;

public class UUIDTimer {
    private static final long kClockOffset = 122192928000000000L;
    private static final long kClockMultiplier = 10000L;
    private static final long kClockMultiplierL = 10000L;
    private final SecureRandom mRnd;
    private final byte[] mClockSequence = new byte[2];
    private long mLastTimeStamp = 0L;
    private int mClockCounter = 0;

    public UUIDTimer(SecureRandom rnd) {
        this.mRnd = rnd;
        this.initTimeStamps();
    }

    private void initTimeStamps() {
        this.mRnd.nextBytes(this.mClockSequence);
        byte[] tmp = new byte[1];
        this.mRnd.nextBytes(tmp);
        this.mClockCounter = tmp[0] & 0xFF;
        this.mLastTimeStamp = 0L;
    }

    public void getTimestamp(byte[] uuidData) {
        uuidData[8] = this.mClockSequence[0];
        uuidData[9] = this.mClockSequence[1];
        long now = System.currentTimeMillis();
        if (now < this.mLastTimeStamp) {
            this.initTimeStamps();
        } else if (now == this.mLastTimeStamp) {
            if ((long)this.mClockCounter == 10000L) {
                this.mClockCounter &= 0xFF;
                do {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                } while ((now = System.currentTimeMillis()) == this.mLastTimeStamp);
                this.mLastTimeStamp = now;
            }
        } else {
            this.mClockCounter &= 0xFF;
            this.mLastTimeStamp = now;
        }
        now *= 10000L;
        now += 122192928000000000L;
        int clockHi = (int)((now += (long)this.mClockCounter) >>> 32);
        int clockLo = (int)now;
        uuidData[6] = (byte)(clockHi >>> 24);
        uuidData[7] = (byte)(clockHi >>> 16);
        uuidData[4] = (byte)(clockHi >>> 8);
        uuidData[5] = (byte)clockHi;
        uuidData[0] = (byte)(clockLo >>> 24);
        uuidData[1] = (byte)(clockLo >>> 16);
        uuidData[2] = (byte)(clockLo >>> 8);
        uuidData[3] = (byte)clockLo;
        ++this.mClockCounter;
    }
}

