/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.doomdark.uuid.EthernetAddress;
import org.doomdark.uuid.TagURI;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDTimer;

public final class UUIDGenerator {
    private static final UUIDGenerator sSingleton = new UUIDGenerator();
    private SecureRandom mRnd = null;
    private final Object mDummyAddressLock = new Object();
    private EthernetAddress mDummyAddress = null;
    private final Object mTimerLock = new Object();
    private UUIDTimer mTimer = null;
    private MessageDigest mHasher = null;

    private UUIDGenerator() {
    }

    public static UUIDGenerator getInstance() {
        return sSingleton;
    }

    public EthernetAddress getDummyAddress() {
        Object object = this.mDummyAddressLock;
        synchronized (object) {
            if (this.mDummyAddress == null) {
                SecureRandom rnd = this.getRandomNumberGenerator();
                byte[] dummy = new byte[6];
                rnd.nextBytes(dummy);
                dummy[0] = (byte)(dummy[0] | 0xFFFFFF80);
                try {
                    this.mDummyAddress = new EthernetAddress(dummy);
                }
                catch (NumberFormatException nex) {
                    // empty catch block
                }
            }
        }
        return this.mDummyAddress;
    }

    public SecureRandom getRandomNumberGenerator() {
        if (this.mRnd == null) {
            this.mRnd = new SecureRandom();
        }
        return this.mRnd;
    }

    public MessageDigest getHashAlgorithm() {
        if (this.mHasher == null) {
            try {
                this.mHasher = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nex) {
                throw new Error("Couldn't instantiate an MD5 MessageDigest instance: " + nex.toString());
            }
        }
        return this.mHasher;
    }

    public UUID generateRandomBasedUUID() {
        return this.generateRandomBasedUUID(this.getRandomNumberGenerator());
    }

    public UUID generateRandomBasedUUID(SecureRandom randomGenerator) {
        byte[] rnd = new byte[16];
        randomGenerator.nextBytes(rnd);
        return new UUID(4, rnd);
    }

    public UUID generateTimeBasedUUID() {
        return this.generateTimeBasedUUID(this.getDummyAddress());
    }

    public UUID generateTimeBasedUUID(EthernetAddress addr) {
        byte[] contents = new byte[16];
        addr.toByteArray(contents, 10);
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer == null) {
                this.mTimer = new UUIDTimer(this.getRandomNumberGenerator());
            }
            this.mTimer.getTimestamp(contents);
        }
        return new UUID(1, contents);
    }

    public UUID generateNameBasedUUID(UUID nameSpaceUUID, String name, MessageDigest digest) {
        digest.reset();
        if (nameSpaceUUID != null) {
            digest.update(nameSpaceUUID.asByteArray());
        }
        digest.update(name.getBytes());
        return new UUID(3, digest.digest());
    }

    public UUID generateNameBasedUUID(UUID nameSpaceUUID, String name) {
        MessageDigest hasher;
        MessageDigest messageDigest = hasher = this.getHashAlgorithm();
        synchronized (messageDigest) {
            UUID uUID = this.generateNameBasedUUID(nameSpaceUUID, name, this.getHashAlgorithm());
            return uUID;
        }
    }

    public UUID generateTagURIBasedUUID(TagURI name) {
        return this.generateNameBasedUUID(null, name.toString());
    }

    public UUID generateTagURIBasedUUID(TagURI name, MessageDigest hasher) {
        return this.generateNameBasedUUID(null, name.toString(), hasher);
    }

    public static void main(String[] args) {
        UUIDGenerator g = UUIDGenerator.getInstance();
        UUID nsUUID = new UUID("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
        System.out.println("UUIDGenerator.main()");
        System.out.println("--------------------");
        System.out.println();
        int ROUNDS = 4;
        int UUID_COUNT = 12;
        TreeSet<UUID> uuids = new TreeSet<UUID>();
        ArrayList<UUID> timebased = new ArrayList<UUID>(4);
        int i = 0;
        while (i < 4) {
            System.out.print("Random UUID: ");
            UUID u = g.generateRandomBasedUUID();
            uuids.add(u);
            UUIDGenerator.doTest(u, System.out, 4);
            System.out.print("Time-based UUID: ");
            u = g.generateTimeBasedUUID();
            uuids.add(u);
            timebased.add(u);
            UUIDGenerator.doTest(u, System.out, 1);
            String name = "test-round-" + i;
            System.out.print("Named-based UUID: (namespace URL, name '" + name + "')");
            u = g.generateNameBasedUUID(nsUUID, name);
            uuids.add(u);
            UUIDGenerator.doTest(u, System.out, 3);
            ++i;
        }
        int count = uuids.size();
        System.out.print("Created 12 uuids; ordered treeset contains " + count);
        System.out.println(count == 12 ? " [OK]" : " [FAIL]");
        System.out.println("Checking ordering:");
        Iterator it = uuids.iterator();
        int prevType = -1;
        System.out.print("Overall ordering by type: ");
        while (it.hasNext()) {
            System.out.print(".");
            UUID uuid = (UUID)it.next();
            int currType = uuid.getType();
            if (currType < prevType) break;
            prevType = currType;
        }
        System.out.println(it.hasNext() ? "FAIL" : "OK");
        it = uuids.iterator();
        int lastIndex = -1;
        System.out.print("Time-based UUID ordering on creation time: ");
        while (it.hasNext()) {
            UUID uuid = (UUID)it.next();
            int index = timebased.indexOf(uuid);
            if (index < 0) continue;
            System.out.print("[");
            System.out.print(index);
            System.out.print("]");
            if (index <= lastIndex) break;
        }
        System.out.println(it.hasNext() ? "FAIL" : "OK");
        UUIDGenerator.doTestNull();
    }

    private static final void doTest(UUID uuid, PrintStream out, int type) {
        System.out.print(uuid.toString());
        System.out.print(" [type: " + uuid.getType());
        System.out.print(", expected " + type);
        System.out.print(type == uuid.getType() ? ": OK" : ": FAIL");
        System.out.println("]");
        System.out.print("... conversion UUID<->String: ");
        try {
            UUID uuid2 = UUID.valueOf(uuid.toString());
            System.out.println(uuid2.toString());
            System.out.print("  -> ");
            System.out.println(uuid.equals(uuid2) ? "OK" : "FAIL");
        }
        catch (NumberFormatException nex) {
            System.out.println("[FAIL: " + nex.toString() + "]");
        }
        System.out.print("... conversion UUID<->byte array: ");
        UUID uuid3 = UUID.valueOf(uuid.asByteArray());
        System.out.println(uuid3.toString());
        System.out.print("  -> ");
        System.out.println(uuid.equals(uuid3) ? "OK" : "FAIL");
        System.out.print("... considered null? ");
        boolean isNull = uuid.isNullUUID();
        System.out.print(isNull);
        System.out.print(" (shouldn't be) -> ");
        System.out.println(isNull ? "FAIL" : "OK");
    }

    private static final void doTestNull() {
        UUID sharedNull = UUID.getNullUUID();
        System.out.println("Testing null UUID checks:");
        System.out.println("-------------------------");
        System.out.print("Testing shared null uuid; considered null: ");
        boolean ok = sharedNull.isNullUUID();
        System.out.print(ok);
        System.out.print("; expected true -> ");
        System.out.println(ok ? "OK" : "FAIL");
        UUID localNull = new UUID(new byte[16]);
        System.out.print("Testing explicit null uuid; considered null: ");
        ok = localNull.isNullUUID();
        System.out.print(ok);
        System.out.print("; expected true -> ");
        System.out.println(ok ? "OK" : "FAIL");
    }
}

