/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.Serializable;

public class UUID
implements Serializable,
Cloneable,
Comparable {
    private static final String kHexChars = "0123456789abcdefABCDEF";
    public static final byte INDEX_CLOCK_HI = 6;
    public static final byte INDEX_CLOCK_MID = 4;
    public static final byte INDEX_CLOCK_LO = 0;
    public static final byte INDEX_TYPE = 6;
    public static final byte INDEX_CLOCK_SEQUENCE = 8;
    public static final byte INDEX_VARIATION = 8;
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_TIME_BASED = 1;
    public static final byte TYPE_DCE = 2;
    public static final byte TYPE_NAME_BASED = 3;
    public static final byte TYPE_RANDOM_BASED = 4;
    public static final String NAMESPACE_DNS = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_URL = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_OID = "6ba7b812-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_X500 = "6ba7b814-9dad-11d1-80b4-00c04fd430c8";
    private static boolean sDescCaching = true;
    private static final UUID sNullUUID = new UUID();
    private final byte[] mId = new byte[16];
    private transient String mDesc = null;
    private transient int mHashCode = 0;
    private static final int[] kShifts = new int[]{3, 7, 17, 21, 29, 4, 9};
    private static final int[] sTimeCompare = new int[]{6, 7, 4, 5, 0, 1, 2, 3};

    public UUID() {
    }

    public UUID(byte[] data) {
        int i = 0;
        while (i < 16) {
            this.mId[i] = data[i];
            ++i;
        }
    }

    public UUID(byte[] data, int start) {
        int i = 0;
        while (i < 16) {
            this.mId[i] = data[start + i];
            ++i;
        }
    }

    UUID(int type, byte[] data) {
        int i = 0;
        while (i < 16) {
            this.mId[i] = data[i];
            ++i;
        }
        this.mId[6] = (byte)(this.mId[6] & 0xF);
        this.mId[6] = (byte)(this.mId[6] | (byte)(type << 4));
        this.mId[8] = (byte)(this.mId[8] & 0x3F);
        this.mId[8] = (byte)(this.mId[8] | 0xFFFFFF80);
    }

    public UUID(String id) throws NumberFormatException {
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.length() != 36) {
            throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
        }
        int i = 0;
        int j = 0;
        while (i < 36) {
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (id.charAt(i) != '-') {
                        throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
                    }
                    ++i;
                }
            }
            char c = id.charAt(i);
            if (c >= '0' && c <= '9') {
                this.mId[j] = (byte)(c - 48 << 4);
            } else if (c >= 'a' && c <= 'f') {
                this.mId[j] = (byte)(c - 97 + 10 << 4);
            } else if (c >= 'A' && c <= 'F') {
                this.mId[j] = (byte)(c - 65 + 10 << 4);
            } else {
                throw new NumberFormatException("Non-hex character '" + c + "'");
            }
            c = id.charAt(++i);
            if (c >= '0' && c <= '9') {
                int n = j;
                this.mId[n] = (byte)(this.mId[n] | (byte)(c - 48));
            } else if (c >= 'a' && c <= 'f') {
                int n = j;
                this.mId[n] = (byte)(this.mId[n] | (byte)(c - 97 + 10));
            } else if (c >= 'A' && c <= 'F') {
                int n = j;
                this.mId[n] = (byte)(this.mId[n] | (byte)(c - 65 + 10));
            } else {
                throw new NumberFormatException("Non-hex character '" + c + "'");
            }
            ++i;
            ++j;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static void setDescCaching(boolean state) {
        sDescCaching = state;
    }

    public static UUID getNullUUID() {
        return sNullUUID;
    }

    public boolean isNullUUID() {
        if (this == sNullUUID) {
            return true;
        }
        byte[] data = this.mId;
        int i = this.mId.length;
        byte zero = 0;
        while (--i >= 0) {
            if (data[i] == zero) continue;
            return false;
        }
        return true;
    }

    public int getType() {
        return (this.mId[6] & 0xFF) >> 4;
    }

    public byte[] asByteArray() {
        byte[] result = new byte[16];
        this.toByteArray(result);
        return result;
    }

    public void toByteArray(byte[] dst, int pos) {
        byte[] src = this.mId;
        int last = pos + 16;
        int i = pos;
        while (i < last) {
            dst[pos + i] = src[i];
            ++i;
        }
    }

    public void toByteArray(byte[] dst) {
        this.toByteArray(dst, 0);
    }

    public byte[] toByteArray() {
        return this.asByteArray();
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            int result = this.mId[0] & 0xFF;
            result |= result << 16;
            result |= result << 8;
            int i = 1;
            while (i < 15) {
                int curr = (this.mId[i] & 0xFF) << 8 | this.mId[i + 1] & 0xFF;
                int shift = kShifts[i >> 1];
                result = shift > 16 ? (result ^= curr << shift | curr >>> 32 - shift) : (result ^= curr << shift);
                i += 2;
            }
            int last = this.mId[15] & 0xFF;
            result ^= last << 3;
            result ^= last << 13;
            this.mHashCode = (result ^= last << 27) == 0 ? -1 : result;
        }
        return this.mHashCode;
    }

    public String toString() {
        if (this.mDesc == null) {
            StringBuffer b = new StringBuffer(36);
            int i = 0;
            while (i < 16) {
                switch (i) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: {
                        b.append('-');
                    }
                }
                int hex = this.mId[i] & 0xFF;
                b.append(kHexChars.charAt(hex >> 4));
                b.append(kHexChars.charAt(hex & 0xF));
                ++i;
            }
            if (!sDescCaching) {
                return b.toString();
            }
            this.mDesc = b.toString();
        }
        return this.mDesc;
    }

    public int compareTo(Object o) {
        int thatType;
        UUID other = (UUID)o;
        int thisType = this.getType();
        if (thisType > (thatType = other.getType())) {
            return 1;
        }
        if (thisType < thatType) {
            return -1;
        }
        byte[] thisId = this.mId;
        byte[] thatId = other.mId;
        int i = 0;
        if (thisType == 1) {
            while (i < 8) {
                int index = sTimeCompare[i];
                int cmp = (thisId[index] & 0xFF) - (thatId[index] & 0xFF);
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
            }
        }
        while (i < 16) {
            int cmp = (thisId[i] & 0xFF) - (thatId[i] & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UUID)) {
            return false;
        }
        byte[] otherId = ((UUID)o).mId;
        byte[] thisId = this.mId;
        int i = 0;
        while (i < 16) {
            if (otherId[i] != thisId[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static UUID valueOf(String id) throws NumberFormatException {
        return new UUID(id);
    }

    public static UUID valueOf(byte[] src, int start) {
        return new UUID(src, start);
    }

    public static UUID valueOf(byte[] src) {
        return new UUID(src);
    }

    private void copyFrom(UUID src) {
        byte[] srcB = src.mId;
        byte[] dstB = this.mId;
        int i = 0;
        while (i < 16) {
            dstB[i] = srcB[i];
            ++i;
        }
        this.mDesc = sDescCaching ? src.mDesc : null;
    }

    public static void main(String[] args) {
    }
}

