/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.util.Calendar;

public class TagURI {
    private final String mDesc;

    public TagURI(String authority, String identifier, Calendar date) {
        StringBuffer b = new StringBuffer();
        b.append("tag:");
        b.append(authority);
        if (date != null) {
            b.append(',');
            b.append(date.get(1));
            int month = date.get(2) - 0 + 1;
            int day = date.get(5);
            if (month != 1 || day != 1) {
                b.append('-');
                b.append(month);
            }
            if (day != 1) {
                b.append('-');
                b.append(day);
            }
        }
        b.append(':');
        b.append(identifier);
        this.mDesc = b.toString();
    }

    public String toString() {
        return this.mDesc;
    }

    public boolean equals(Object o) {
        if (o instanceof TagURI) {
            return this.mDesc.equals(((TagURI)o).toString());
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println("TagURI.main()");
        System.out.println("--------------------");
        System.out.println();
        String[] auths = new String[]{"www.w3c.org", "www.google.com", "www.fi", "tatu.saloranta@iki.fi"};
        String[] ids = new String[]{"1234", "/home/billg/public_html/index.html", "6ba7b810-9dad-11d1-80b4-00c04fd430c8", "foobar"};
        Calendar c = null;
        Object auth = null;
        int i = 0;
        while (i < 4) {
            switch (i) {
                case 2: {
                    c.add(2, 1);
                    break;
                }
                case 3: {
                    c.add(5, -7);
                }
            }
            int j = 0;
            while (j < 4) {
                TagURI t = new TagURI(auths[i], ids[j], c);
                System.out.println("tagURI: " + t);
                ++j;
            }
            if (c == null) {
                c = Calendar.getInstance();
            }
            ++i;
        }
    }
}

