/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.Serializable;

public class EthernetAddress
implements Serializable,
Cloneable,
Comparable {
    private static final String kHexChars = "0123456789abcdefABCDEF";
    private final byte[] mAddress;

    public EthernetAddress(String addrStr) throws NumberFormatException {
        byte[] addr = this.mAddress = new byte[6];
        int len = addrStr.length();
        int i = 0;
        int j = 0;
        while (j < 6) {
            int value;
            if (i >= len) {
                if (j == 5) {
                    addr[5] = 0;
                    break;
                }
                throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
            }
            char c = addrStr.charAt(i);
            ++i;
            if (c == ':') {
                value = 0;
            } else {
                if (c >= '0' && c <= '9') {
                    value = c - 48;
                } else if (c >= 'a' && c <= 'f') {
                    value = c - 97 + 10;
                } else if (c >= 'A' && c <= 'F') {
                    value = c - 65 + 10;
                } else {
                    throw new NumberFormatException("Non-hex character '" + c + "'");
                }
                if (i < len) {
                    c = addrStr.charAt(i);
                    ++i;
                    if (c != ':') {
                        value <<= 4;
                        if (c >= '0' && c <= '9') {
                            value |= c - 48;
                        } else if (c >= 'a' && c <= 'f') {
                            value |= c - 97 + 10;
                        } else if (c >= 'A' && c <= 'F') {
                            value |= c - 65 + 10;
                        } else {
                            throw new NumberFormatException("Non-hex character '" + c + "'");
                        }
                    }
                }
            }
            addr[j] = (byte)value;
            if (c != ':') {
                if (i < len) {
                    if (addrStr.charAt(i) != ':') {
                        throw new NumberFormatException("Expected ':', got ('" + addrStr.charAt(i) + "')");
                    }
                    ++i;
                } else if (j < 5) {
                    throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
                }
            }
            ++j;
        }
    }

    public EthernetAddress(byte[] addr) throws NumberFormatException {
        this.mAddress = new byte[6];
        if (addr.length != 6) {
            throw new NumberFormatException("Ethernet address has to consist of 6 bytes");
        }
        int i = 0;
        while (i < 6) {
            this.mAddress[i] = addr[i];
            ++i;
        }
    }

    public EthernetAddress(long addr) {
        this.mAddress = new byte[6];
        int i = 0;
        while (i < 6) {
            this.mAddress[5 - i] = (byte)addr;
            addr >>>= 8;
            ++i;
        }
    }

    EthernetAddress() {
        this.mAddress = new byte[6];
        byte z = 0;
        int i = 0;
        while (i < 6) {
            this.mAddress[i] = z;
            ++i;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof EthernetAddress)) {
            return false;
        }
        byte[] otherAddress = ((EthernetAddress)o).mAddress;
        byte[] thisAddress = this.mAddress;
        int i = 0;
        while (i < 6) {
            if (otherAddress[i] != thisAddress[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int compareTo(Object o) {
        byte[] thatA = ((EthernetAddress)o).mAddress;
        byte[] thisA = this.mAddress;
        int i = 0;
        while (i < 6) {
            int cmp = (thisA[i] & 0xFF) - (thatA[i] & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(17);
        byte[] addr = this.mAddress;
        int i = 0;
        while (i < 6) {
            if (i > 0) {
                b.append(":");
            }
            int hex = addr[i] & 0xFF;
            b.append(kHexChars.charAt(hex >> 4));
            b.append(kHexChars.charAt(hex & 0xF));
            ++i;
        }
        return b.toString();
    }

    public byte[] asByteArray() {
        byte[] result = new byte[6];
        this.toByteArray(result);
        return result;
    }

    public byte[] toByteArray() {
        return this.asByteArray();
    }

    public void toByteArray(byte[] array) {
        this.toByteArray(array, 0);
    }

    public void toByteArray(byte[] array, int pos) {
        int i = 0;
        while (i < 6) {
            array[pos + i] = this.mAddress[i];
            ++i;
        }
    }

    public long toLong() {
        byte[] addr = this.mAddress;
        int hi = (addr[0] & 0xFF) << 8 | addr[1] & 0xFF;
        int lo = addr[2] & 0xFF;
        int i = 3;
        while (i < 6) {
            lo = lo << 8 | addr[i] & 0xFF;
            ++i;
        }
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static EthernetAddress valueOf(byte[] addr) throws NumberFormatException {
        return new EthernetAddress(addr);
    }

    public static EthernetAddress valueOf(int[] addr) throws NumberFormatException {
        byte[] bAddr = new byte[addr.length];
        int i = 0;
        while (i < addr.length) {
            bAddr[i] = (byte)addr[i];
            ++i;
        }
        return new EthernetAddress(bAddr);
    }

    public static EthernetAddress valueOf(String addrStr) throws NumberFormatException {
        return new EthernetAddress(addrStr);
    }

    public static EthernetAddress valueOf(long addr) {
        return new EthernetAddress(addr);
    }

    public static void main(String[] args) {
        System.out.println("EthernetAddress.main, test:");
        System.out.println("---------------------------");
        long rnd = 0L;
        if (args == null || args.length == 0) {
            System.out.println("[no address passed, using a random address]");
            boolean len = true;
            rnd = System.currentTimeMillis() ^ (long)(Math.random() * 4.294967296E9);
            args = new String[]{new EthernetAddress(rnd).toString()};
        }
        int i = 0;
        while (i < args.length) {
            block6: {
                String s = args[i];
                System.out.println("Address '" + s + "':");
                try {
                    EthernetAddress a = EthernetAddress.valueOf(s);
                    System.err.println("  Ok, comes out as '" + a.toString() + "'");
                    System.err.print("  Converting to long, result = ");
                    long l = a.toLong();
                    System.err.println("" + Long.toHexString(l));
                    System.err.print("  Creating address from long, are equal: ");
                    EthernetAddress b = EthernetAddress.valueOf(l);
                    if (!b.equals(a)) {
                        System.err.println("no (FAIL)");
                        break;
                    }
                    System.err.println("yes (OK)");
                    System.err.println("  Converting to byte array.");
                    byte[] ba = a.asByteArray();
                    System.err.print("  Creating address from byte[], are equal: ");
                    b = EthernetAddress.valueOf(ba);
                    if (b.equals(a)) {
                        System.err.println("yes (OK)");
                        break block6;
                    }
                    System.err.println("no (FAIL)");
                    break;
                }
                catch (NumberFormatException e) {
                    System.out.println("  Fail: " + e.toString());
                }
            }
            ++i;
        }
        System.out.println("---------------------------");
        System.out.println("Done.");
    }
}

