/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

import java.io.IOException;
import java.io.InputStream;
import moos.deployed.DebugMessage;
import moos.deployed.TimeoutException;
import moos.utils.StopWatch;

public class StreamUtils {
    public static int skipUntil(InputStream is, byte[] term, long timeout) throws TimeoutException, IOException, NullPointerException, Exception {
        int termCharCount = 0;
        int totalCharsRead = 0;
        StopWatch skipTimer = new StopWatch(true);
        if (term == null) {
            return 0;
        }
        do {
            if (is.available() <= 0) continue;
            int c = is.read();
            ++totalCharsRead;
            if (c == term[termCharCount]) {
                if (++termCharCount != term.length) continue;
                return totalCharsRead;
            }
            termCharCount = 0;
        } while (skipTimer.read() <= timeout);
        throw new TimeoutException("skipUntil(): Timed out");
    }

    private static void checkReadUntilArgs(InputStream input, byte[] output, byte[] terminator) throws NullPointerException {
        if (input == null) {
            throw new NullPointerException("readUntil called with null InputStream");
        }
        if (output == null) {
            throw new NullPointerException("readUntil called with null output buffer");
        }
        if (terminator == null) {
            throw new NullPointerException("readUntil called with null terminator");
        }
    }

    private static void checkSkipUntilArgs(InputStream input, byte[] terminator) throws NullPointerException {
        if (input == null) {
            throw new NullPointerException("skipUntil called with null InputStream");
        }
        if (terminator == null) {
            throw new NullPointerException("skipUntil called with null terminator");
        }
    }

    private static boolean foundTerminator(byte[] buffer, int totalBytesRead, byte[] terminator) {
        int termSz = terminator.length;
        if (totalBytesRead < termSz) {
            return false;
        }
        int offset = totalBytesRead - termSz;
        boolean matches = false;
        int i = 0;
        while (i < termSz) {
            if (buffer[i + offset] != terminator[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readUntil(InputStream instream, byte[] outbuf, byte[] terminator, long timeout) throws TimeoutException, NullPointerException, IOException, Exception {
        int n;
        int bytesRead = 0;
        long elapsed = 0L;
        try {
            block4: {
                StreamUtils.checkReadUntilArgs(instream, outbuf, terminator);
                long t0 = System.currentTimeMillis();
                byte lastbyte = terminator[terminator.length - 1];
                do {
                    if (instream.available() <= 0) continue;
                    int c = instream.read();
                    outbuf[bytesRead++] = (byte)c;
                    if (c != lastbyte || !StreamUtils.foundTerminator(outbuf, bytesRead, terminator)) {
                        if (bytesRead < outbuf.length) continue;
                        throw new Exception("Output buf in instrument driver exceeded (buffer max length is " + outbuf.length + ")");
                    }
                    break block4;
                } while ((elapsed = System.currentTimeMillis() - t0) <= timeout);
                throw new TimeoutException("Timed out");
            }
            n = bytesRead - terminator.length;
            Object var14_10 = null;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            long debug_level = DebugMessage.getLevel();
            DebugMessage.setLevel(0L);
            DebugMessage.println("leaving readUntil");
            DebugMessage.println("bytesRead = " + bytesRead);
            DebugMessage.println("outbuf len = " + outbuf.length);
            DebugMessage.println("elapsed = " + elapsed);
            DebugMessage.setLevel(debug_level);
            throw throwable;
        }
        long debug_level = DebugMessage.getLevel();
        DebugMessage.setLevel(0L);
        DebugMessage.println("leaving readUntil");
        DebugMessage.println("bytesRead = " + bytesRead);
        DebugMessage.println("outbuf len = " + outbuf.length);
        DebugMessage.println("elapsed = " + elapsed);
        DebugMessage.setLevel(debug_level);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int skipUntil(InputStream instream, byte[] terminator, long timeout, int maxBytes) throws TimeoutException, NullPointerException, IOException, Exception {
        int n;
        long debug_level = DebugMessage.getLevel();
        DebugMessage.println("entring skipUntil(terminator: " + new String(terminator) + " )");
        int bytesSkipped = 0;
        long elapsed = 0L;
        try {
            block4: {
                StreamUtils.checkSkipUntilArgs(instream, terminator);
                long t0 = System.currentTimeMillis();
                int i = 0;
                do {
                    if (instream.available() > 0) {
                        int c = instream.read();
                        i = c == terminator[i] ? ++i : 0;
                        ++bytesSkipped;
                        if (i == terminator.length) break block4;
                    }
                    if (maxBytes <= 0 || bytesSkipped < maxBytes) continue;
                    throw new Exception("Exceeded maxBytes");
                } while (timeout <= 0L || (elapsed = System.currentTimeMillis() - t0) <= timeout);
                throw new TimeoutException("Timed out");
            }
            DebugMessage.println("SkipUntil(): found terminator: " + new String(terminator));
            n = bytesSkipped - terminator.length;
            Object var16_11 = null;
        }
        catch (Throwable throwable) {
            Object var16_12 = null;
            DebugMessage.println("leaving skipUntil");
            DebugMessage.println("bytesSkipped = " + bytesSkipped);
            DebugMessage.println("elapsed = " + elapsed);
            DebugMessage.setLevel(debug_level);
            throw throwable;
        }
        DebugMessage.println("leaving skipUntil");
        DebugMessage.println("bytesSkipped = " + bytesSkipped);
        DebugMessage.println("elapsed = " + elapsed);
        DebugMessage.setLevel(debug_level);
        return n;
    }
}

