/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

public class StopWatch {
    private boolean _active = false;
    private long _refTime;
    private long _totalTime = 0L;

    public StopWatch() {
    }

    public StopWatch(boolean create_running) {
        if (create_running) {
            this.start();
        }
    }

    public boolean isRunning() {
        return this._active;
    }

    public void clear() {
        this._totalTime = 0L;
    }

    public long read() {
        long current_time = System.currentTimeMillis();
        if (this._active) {
            this._totalTime += current_time - this._refTime;
        }
        this._refTime = current_time;
        return this._totalTime;
    }

    public long start() {
        this.read();
        this._active = true;
        return this._totalTime;
    }

    public long stop() {
        this.read();
        this._active = false;
        return this._totalTime;
    }

    public static void delay(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (Exception e) {
            System.out.println("wait(...) failed");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        StopWatch app = new StopWatch();
        app.stopWatchTest();
        System.exit(0);
    }

    public void stopWatchTest() {
        System.out.println("[Time shoud equal to 0     ] time = " + this.read());
        this.start();
        StopWatch.delay(500);
        System.out.println("[Time shoud be approx 500  ] time = " + this.read());
        StopWatch.delay(500);
        this.stop();
        System.out.println("[Time shoud be approx 1000 ] time = " + this.read());
        StopWatch.delay(1000);
        System.out.println("[Time shoud equal last read] time = " + this.read());
    }
}

