/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;

public class RXTXTest {
    SerialPort _serialPort;
    String _serialPortName;
    static final int _TEST_BAUD = 38400;

    public static void main(String[] args) {
        RXTXTest app = null;
        if (args[0] != null) {
            app = new RXTXTest(args[0]);
        } else {
            System.out.println("need to specify a comm port");
            System.exit(0);
        }
        try {
            app.execute();
        }
        catch (Exception e) {
            System.err.println("RXTX.execute() caught Exception: " + e);
            e.printStackTrace();
            System.exit(0);
        }
        System.exit(0);
    }

    public RXTXTest(String port_name) {
        this._serialPortName = port_name;
        System.setProperty("gnu.io.rxtx.SerialPorts", port_name);
    }

    public void execute() throws Exception {
        InputStream is = null;
        OutputStream os = null;
        while (true) {
            System.out.println("-----------------------------------");
            System.out.println("...opening the serial port");
            this.initSerialPort(this._serialPortName);
            is = this._serialPort.getInputStream();
            os = this._serialPort.getOutputStream();
            System.out.println("...setting baud rate to 38400");
            this._serialPort.setSerialPortParams(38400, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
            System.out.println("...writing some stuff");
            os.write("hello from tx pin".getBytes());
            this.delay(10);
            System.out.println("...reading some stuff");
            while (is.available() > 0) {
                System.out.write(is.read());
            }
            System.out.println("");
            System.out.println("...setting the RTS line");
            this._serialPort.setRTS(true);
            System.out.println("...checking the CTS line");
            if (this._serialPort.isCTS()) {
                System.out.println("CTS is set");
            } else {
                System.out.println("CTS is clear");
            }
            System.out.println("...closing the serial port");
            this._serialPort.close();
            System.out.println("...waiting 5 seconds");
            this.delay(5000);
        }
    }

    private void initSerialPort(String port_name) throws Exception {
        CommPortIdentifier commPortId = CommPortIdentifier.getPortIdentifier((String)port_name);
        this._serialPort = (SerialPort)commPortId.open(this.getClass().getName(), 1000);
        System.out.println("Serial port " + port_name + " opened by " + this.getClass().getName());
    }

    private void delay(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (Exception e) {
            System.out.println("delay(...) failed");
            e.printStackTrace();
        }
    }
}

