/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

import moos.utils.PrintfFormat;

public class PrintUtils {
    static final PrintUtils _p = new PrintUtils();
    static int _width = 16;

    private PrintUtils() {
    }

    private void printOffset(int i) {
        String str = new PrintfFormat("%04i").sprintf(i);
        System.out.print(str);
    }

    private int printHex(byte[] buf, int offset, int count) {
        String str = "";
        int i = offset;
        while (i < buf.length && i < offset + count) {
            str = str + (i == offset + 8 ? "-" : " ");
            str = str + new PrintfFormat("%02x").sprintf(buf[i] & 0xFF);
            ++i;
        }
        System.out.print(str);
        return i - offset;
    }

    private boolean isPrintable(byte ch) {
        return ch > 31 && ch <= 127;
    }

    private void printSpace(int count) {
        int i = 0;
        while (i < count) {
            System.out.print(" ");
            ++i;
        }
    }

    private int min(int a, int b) {
        return a < b ? a : b;
    }

    public static void setWidth(int width) {
        _width = width;
    }

    public static String getAscii(byte[] buf, int offset, int count) throws IllegalArgumentException {
        if (offset + count > buf.length) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        String str = "";
        int i = offset;
        while (i < buf.length && i < offset + count) {
            str = str + (_p.isPrintable(buf[i]) ? new String(buf, i, 1) : ".");
            ++i;
        }
        return str;
    }

    public static synchronized int printAscii(byte[] buf, int offset, int count) throws IllegalArgumentException {
        if (offset + count > buf.length) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        String str = "";
        int i = offset;
        while (i < buf.length && i < offset + count) {
            str = str + (_p.isPrintable(buf[i]) ? new String(buf, i, 1) : ".");
            ++i;
        }
        System.out.print(str);
        return i - offset;
    }

    public static synchronized void printFull(byte[] buf, int offset, int count) throws IllegalArgumentException {
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        int org = offset;
        while (offset < buf.length && offset - org < count) {
            _p.printOffset(offset);
            _p.printSpace(2);
            int printed = _p.printHex(buf, offset, _p.min(count, _width));
            _p.printSpace((_width - printed) * 3 + 4);
            PrintUtils.printAscii(buf, offset, printed);
            System.out.println("");
            if (_width != printed) break;
            offset += _width;
        }
    }
}

