/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

import gnu.getopt.Getopt;
import moos.deployed.DpaBoard;
import moos.deployed.SpiMaster;

public class DpaPortTo485 {
    private static final int TOTAL_DPA_CHANS = 8;
    private static final int TOTAL_DPA_BOARDS = 4;
    private static DpaBoard.DpaChannel[] _dpaChannels = new DpaBoard.DpaChannel[8];
    private static int[] _spiSlaveIndex = new int[]{0, 1, 2, 3};
    private static SpiMaster _spi = SpiMaster.getInstance();

    public static void main(String[] args) {
        DpaPortTo485 app = new DpaPortTo485();
        app.scanDpas();
        app.execute(args);
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public void execute(String[] args) {
        int c;
        Getopt g = new Getopt(this.getClass().getName(), args, "c:s:h");
        String slot = null;
        String chan = null;
        while ((c = g.getopt()) != -1) {
            void var3_5;
            switch (var3_5) {
                case 99: {
                    chan = g.getOptarg();
                    break;
                }
                case 115: {
                    slot = g.getOptarg();
                    break;
                }
                default: {
                    this.showHelp();
                    return;
                }
            }
        }
        if (!this.checkSlot(slot)) {
            System.out.println("Slot '" + slot + "' not valid");
            this.showHelp();
            return;
        }
        if (!this.checkChannel(chan)) {
            System.out.println("Channel '" + chan + "' not valid");
            this.showHelp();
            return;
        }
        int chan_int = Integer.parseInt(chan.trim());
        int slot_int = Integer.parseInt(slot.trim());
        System.out.println("Setting DPA slot '" + slot_int + "' channel '" + chan_int + "' to RS-485");
        this.setPort485(slot_int, chan_int);
    }

    void showHelp() {
        System.out.println("usage: java -cp . moos.utils.SetDpaPort -c channel -s slot -l loop_mode");
    }

    void setPort485(int slot, int chan) {
        int channelIndex = 2 * slot + chan;
        if (_dpaChannels[channelIndex] != null) {
            DpaPortTo485._dpaChannels[channelIndex]._relayReg.connect485Terminators();
            DpaPortTo485._dpaChannels[channelIndex]._relayReg.connectCommunicationsGround();
            DpaPortTo485._dpaChannels[channelIndex]._relayReg.isolateInstrumentPower();
            DpaPortTo485._dpaChannels[channelIndex]._relayReg.write();
            DpaPortTo485._dpaChannels[channelIndex]._channelCtrlReg.setCommModeRs485();
            DpaPortTo485._dpaChannels[channelIndex]._channelCtrlReg.setCommFullDuplex();
            DpaPortTo485._dpaChannels[channelIndex]._channelCtrlReg.setCommPowerOn();
            DpaPortTo485._dpaChannels[channelIndex]._channelCtrlReg.setSlewRateNotLimited();
            DpaPortTo485._dpaChannels[channelIndex]._channelCtrlReg.setTxHiPower();
            DpaPortTo485._dpaChannels[channelIndex]._channelCtrlReg.write();
        } else {
            System.err.println("DPA channel at slot '" + slot + "' channel '" + chan + "' is not available");
        }
    }

    void scanDpas() {
        int i = 0;
        while (i < 4) {
            int channelIndex = 2 * i;
            if (DpaBoard.checkForDpaHardware(_spiSlaveIndex[i])) {
                System.err.println("Found DPA at slot: " + i);
                DpaBoard dpa = new DpaBoard(_spiSlaveIndex[i]);
                DpaPortTo485._dpaChannels[channelIndex] = dpa.getLeftChannel();
                _dpaChannels[channelIndex].initializeChannel();
                DpaPortTo485._dpaChannels[++channelIndex] = dpa.getRightChannel();
                _dpaChannels[channelIndex].initializeChannel();
            } else {
                System.err.println("No DPA Found at slot: " + i);
                DpaPortTo485._dpaChannels[channelIndex] = null;
                DpaPortTo485._dpaChannels[++channelIndex] = null;
            }
            ++i;
        }
    }

    boolean checkSlot(String slot) {
        if (slot == null) {
            return false;
        }
        int i = Integer.parseInt(slot.trim());
        return i < 4 && i > -1;
    }

    boolean checkChannel(String chan) {
        if (chan == null) {
            return false;
        }
        int i = Integer.parseInt(chan.trim());
        return i == 0 || i == 1;
    }

    boolean checkLoop(String loop) {
        if (loop == null) {
            return false;
        }
        int i = Integer.parseInt(loop.trim());
        return i == 0 || i == 1;
    }
}

