/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;

public class CommIoTest {
    CommPortIdentifier commPortId;
    SerialPort serialPort;

    public static void main(String[] args) {
        CommIoTest test = null;
        if (args[0] != null) {
            test = new CommIoTest(args[0]);
        } else {
            System.out.println("need to specify a comm port");
            System.exit(0);
        }
        test.TestExecute(args);
        System.exit(0);
    }

    public void showIoMap() {
        System.out.println("");
        System.out.println("The wiring for the DPA ports is as follows for a DTE connector");
        System.out.println("out of the back plane.");
        System.out.println("");
        System.out.println("---------------------------------------------------------------");
        System.out.println("|   DB-9 male  |   5 pin DPA    |   Function   |  wire color* |");
        System.out.println("---------------------------------------------------------------");
        System.out.println("|    3         |       1        |  TX  (out)   |  green       |");
        System.out.println("|    7         |       2        |  RTS (out)   |  yellow      |");
        System.out.println("|    2         |       3        |  RX  (in)    |  orange      |");
        System.out.println("|    8         |       4        |  CTS (in)    |  red         |");
        System.out.println("|    5         |       5        |  GND         |  brown       |");
        System.out.println("---------------------------------------------------------------");
        System.out.println("");
        System.out.println("*Wire colors as of last batch (2/2003) of connectors.  Note: this");
        System.out.println("is not a standard, do not count on it!!!");
        System.out.println("");
    }

    public CommIoTest(String port_name) {
        try {
            this.initSerialPort(port_name);
        }
        catch (Exception e) {
            System.err.println("CommIoTest threw exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void TestExecute(String[] args) {
        if (args[1] == null) {
            this.showHelp();
        }
        if (args[1].trim().compareTo("-help") == 0) {
            this.showHelp();
        }
        if (args[1].trim().compareTo("-pinout") == 0) {
            this.showIoMap();
        }
        if (args[1].trim().compareTo("-rts_loop") == 0) {
            while (true) {
                this.serialPort.setRTS(true);
                System.out.println("RTS set hi");
                this.delay(1500);
                this.serialPort.setRTS(false);
                System.out.println("RTS set lo");
                this.delay(1500);
            }
        }
        if (args[1].trim().compareTo("-cts_loop") == 0) {
            System.out.println("RTS set hi");
            while (true) {
                this.delay(1000);
                if (this.serialPort.isCTS()) {
                    System.out.println("CTS is hi");
                    continue;
                }
                System.out.println("CTS is lo");
            }
        }
    }

    void showHelp() {
        System.out.println("-help     - show this menu");
        System.out.println("-rts_loop - toggle RTS output");
        System.out.println("-cts_loop - read CTS input");
        System.out.println("-pinout   - display serial io pinout diagram");
    }

    private void initSerialPort(String port_name) throws Exception {
        this.commPortId = CommPortIdentifier.getPortIdentifier((String)port_name);
        this.serialPort = (SerialPort)this.commPortId.open(this.getClass().getName(), 1000);
        System.out.println("Serial port " + port_name + " opened by " + this.getClass().getName());
    }

    private void delay(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (Exception e) {
            System.out.println("delay(...) failed");
            e.printStackTrace();
        }
    }
}

