/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

import moos.deployed.RangeException;

public final class ByteUtility {
    private static final int _INT_BIT_MASK = 255;
    private static final long _LONG_BIT_MASK = 255L;

    public static boolean checkByteArrayLen(byte[] buf, int len) {
        return len > 0 && len <= buf.length;
    }

    public static boolean checkByteArrayOffset(byte[] buf, int offset) {
        return offset >= 0 && offset <= buf.length;
    }

    public static boolean checkByteArrayRange(byte[] buf, int len, int offset) {
        if (!ByteUtility.checkByteArrayLen(buf, len)) {
            return false;
        }
        if (!ByteUtility.checkByteArrayOffset(buf, offset)) {
            return false;
        }
        return offset + len < buf.length;
    }

    public static boolean byteArrayEquals(byte[] firstArray, byte[] secondArray) throws RangeException {
        return ByteUtility.byteArrayEquals(firstArray, 0, secondArray, 0, firstArray.length) == 0;
    }

    public static boolean byteArrayEquals(byte[] firstArray, byte[] secondArray, int len) throws RangeException {
        return ByteUtility.byteArrayEquals(firstArray, 0, secondArray, 0, len) == 0;
    }

    public static int byteArrayEquals(byte[] firstArray, int firstOffset, byte[] secondArray, int secondOffset, int len) throws RangeException {
        if (!ByteUtility.checkByteArrayRange(firstArray, firstOffset, len)) {
            throw new RangeException("invalid firstArray range");
        }
        if (!ByteUtility.checkByteArrayRange(secondArray, secondOffset, len)) {
            throw new RangeException("invalid secondArray range");
        }
        int i = 0;
        while (i < len) {
            if (firstArray[firstOffset + i] > secondArray[secondOffset + i]) {
                return 1;
            }
            if (firstArray[firstOffset + i] < secondArray[secondOffset + i]) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public static void fillByteArray(byte[] array, char fillChar) {
        ByteUtility.fillByteSubArray(array, 0, array.length, fillChar);
    }

    public static void fillByteSubArray(byte[] array, int fromIndex, int toIndex, char fillChar) {
        int i = fromIndex;
        while (i < toIndex && i < array.length) {
            array[i] = (byte)fillChar;
            ++i;
        }
    }

    public static byte[] getByteSubArray(byte[] b, int offset, int len) throws RangeException {
        byte[] retval = new byte[len];
        if (offset < 0 || offset > b.length) {
            throw new RangeException("Invalid offset");
        }
        if (len <= 0 || len > b.length) {
            throw new RangeException("Invalid length");
        }
        if (offset + len > b.length) {
            throw new RangeException("Exceeded Array Bounds");
        }
        int i = 0;
        while (i < len) {
            retval[i] = b[i + offset];
            ++i;
        }
        return retval;
    }

    public static byte[] concatByteArrays(byte[] firstBuf, byte[] secondBuf) throws RangeException {
        return ByteUtility.concatByteArrays(firstBuf, 0, firstBuf.length, secondBuf, 0, secondBuf.length);
    }

    public static byte[] concatByteArrays(byte[] firstBuf, int firstLen, byte[] secondBuf, int secondLen) throws RangeException {
        return ByteUtility.concatByteArrays(firstBuf, 0, firstLen, secondBuf, 0, secondLen);
    }

    public static byte[] concatByteArrays(byte[] firstBuf, int firstOffset, int firstLen, byte[] secondBuf, int secondOffset, int secondLen) throws RangeException {
        if (firstOffset < 0 || firstOffset > firstBuf.length) {
            throw new RangeException("Invalid Offset (1)");
        }
        if (secondOffset < 0 || secondOffset > secondBuf.length) {
            throw new RangeException("Invalid Offset (2)");
        }
        if (firstLen <= 0 || firstLen > firstBuf.length) {
            throw new RangeException("Invalid Length (1)");
        }
        if (secondLen <= 0 || secondLen > secondBuf.length) {
            throw new RangeException("Invalid Length (2)");
        }
        if (firstOffset + firstLen > firstBuf.length) {
            throw new RangeException("Exceeded Buffer length (1)");
        }
        if (secondOffset + secondLen > secondBuf.length) {
            throw new RangeException("Exceeded Buffer length (2)");
        }
        int L1 = firstLen - firstOffset;
        int L2 = secondLen - secondOffset;
        byte[] retval = new byte[L1 + L2];
        int i = 0;
        int j = 0;
        i = firstOffset;
        while (i < firstOffset + L1) {
            retval[i] = firstBuf[i];
            ++i;
        }
        j = secondOffset;
        while (j < secondOffset + L2) {
            retval[j + i] = secondBuf[j];
            ++j;
        }
        return retval;
    }

    public static byte[] intToBytes(int value) {
        byte[] b = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)};
        return b;
    }

    public static byte[] longToBytes(long value) {
        byte[] b = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 0 & 0xFFL)};
        return b;
    }

    public static int bytesToInt(byte[] bytes) throws RangeException {
        return ByteUtility.bytesToInt(bytes, 0);
    }

    public static long bytesToLong(byte[] bytes) throws RangeException {
        return ByteUtility.bytesToLong(bytes, 0);
    }

    public static int bytesToInt(byte[] bytes, int offset) throws RangeException {
        int result = 0;
        if (bytes.length - offset < 4) {
            throw new RangeException("byte array to short for integer converison");
        }
        int i = 0;
        while (i < 4) {
            int shifter = bytes[i + offset] & 0xFF;
            result += shifter << (3 - i) * 8;
            ++i;
        }
        return result;
    }

    public static long bytesToLong(byte[] bytes, int offset) throws RangeException {
        long result = 0L;
        if (bytes.length - offset < 8) {
            throw new RangeException("byte array to short for long converison");
        }
        int i = 0;
        while (i < 8) {
            long shifter = (long)bytes[i + offset] & 0xFFL;
            result += shifter << (7 - i) * 8;
            ++i;
        }
        return result;
    }
}

