/*
 * Decompiled with CFR 0.152.
 */
package moos.utils;

import java.util.Calendar;
import java.util.TimeZone;

public class AsciiTime {
    private static Calendar _time;
    protected static int _month;
    protected static int _date;
    protected static int _year;
    protected static int _day;
    protected static int _hour24;
    protected static int _hour12;
    protected static int _minute;
    protected static int _second;

    private AsciiTime() {
    }

    public static synchronized String getTime(String formatString) {
        return AsciiTime.getTime(formatString, "UTC");
    }

    public static synchronized String getTime(String formatString, String timeZone) {
        _time = Calendar.getInstance();
        _time.setTimeZone(TimeZone.getTimeZone(timeZone));
        _hour24 = _time.get(11);
        _hour12 = _time.get(10);
        _minute = _time.get(12);
        _second = _time.get(13);
        int H2 = formatString.indexOf("HH");
        int h2 = formatString.indexOf("hh");
        int m2 = formatString.indexOf("mm");
        int s2 = formatString.indexOf("ss");
        char[] str = new char[formatString.length()];
        formatString.getChars(0, formatString.length(), str, 0);
        if (H2 >= 0) {
            str[H2] = Character.forDigit(_hour24 / 10, 10);
            str[H2 + 1] = Character.forDigit(_hour24 % 10, 10);
        }
        if (h2 >= 0) {
            str[h2] = Character.forDigit(_hour12 / 10, 10);
            str[h2 + 1] = Character.forDigit(_hour12 % 10, 10);
        }
        if (m2 >= 0) {
            str[m2] = Character.forDigit(_minute / 10, 10);
            str[m2 + 1] = Character.forDigit(_minute % 10, 10);
        }
        if (s2 >= 0) {
            str[s2] = Character.forDigit(_second / 10, 10);
            str[s2 + 1] = Character.forDigit(_second % 10, 10);
        }
        return new String(str);
    }

    public static synchronized String getDate(String formatString) {
        return AsciiTime.getDate(formatString, "UTC");
    }

    public static synchronized String getDate(String formatString, String timeZone) {
        _time = Calendar.getInstance();
        _time.setTimeZone(TimeZone.getTimeZone(timeZone));
        _month = _time.get(2) + 1;
        _date = _time.get(5);
        _year = _time.get(1);
        _day = _time.get(6);
        int m2 = formatString.indexOf("MM");
        int d1 = formatString.indexOf("ddd");
        int d2 = formatString.indexOf("DD");
        int y4 = formatString.indexOf("YYYY");
        int y2 = formatString.indexOf("YY");
        if (y4 >= 0) {
            y2 = -1;
        }
        char[] str = new char[formatString.length()];
        formatString.getChars(0, formatString.length(), str, 0);
        if (m2 >= 0) {
            str[m2] = Character.forDigit(_month / 10, 10);
            str[m2 + 1] = Character.forDigit(_month % 10, 10);
        }
        if (d1 >= 0) {
            str[d1] = Character.forDigit(_day / 100, 10);
            str[d1 + 1] = Character.forDigit(_day % 100 / 10, 10);
            str[d1 + 2] = Character.forDigit(_day % 10, 10);
        }
        if (d2 >= 0) {
            str[d2] = Character.forDigit(_date / 10, 10);
            str[d2 + 1] = Character.forDigit(_date % 10, 10);
        }
        if (y2 >= 0) {
            str[y2] = Character.forDigit(_year % 100 / 10, 10);
            str[y2 + 1] = Character.forDigit(_year % 10, 10);
        }
        if (y4 >= 0) {
            str[y4] = Character.forDigit(_year / 1000, 10);
            str[y4 + 1] = Character.forDigit(_year % 1000 / 100, 10);
            str[y4 + 2] = Character.forDigit(_year % 100 / 10, 10);
            str[y4 + 3] = Character.forDigit(_year % 10, 10);
        }
        return new String(str);
    }

    public static void main(String[] args) {
        String date = AsciiTime.getDate("MM/DD/YYYY");
        String time = AsciiTime.getTime("hh:mm:ss");
        System.out.println(date + " " + time);
        while (true) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        date = AsciiTime.getDate("Day:ddd Month:MM Date:DD Year:YY");
        time = AsciiTime.getTime("HH:hh:mm:ss");
        System.out.println(date + " " + time);
    }
}

