/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.nodeview.monitor;

import java.util.StringTokenizer;
import java.util.Vector;
import moos.operations.utils.nodeview.monitor.SensorPacketParser;
import org.mbari.isi.interfaces.SensorDataPacket;

public class EnvironmentalPacketParser
extends SensorPacketParser {
    public static final int TEMPERATURE = 5;
    public static final int PRESSURE = 6;
    public static final int HUMIDITY = 7;
    public static final int GFLO = 8;
    public static final int GFHI = 9;
    public static final int ENVIRONMENTAL_PACKET_FIELDS = 10;

    public EnvironmentalPacketParser() {
        this._fields.setSize(10);
    }

    public EnvironmentalPacketParser(SensorDataPacket packet) {
        this._fields.setSize(10);
        this.parse(packet);
    }

    public Double getDouble(String token, int start) {
        return new Double(Double.parseDouble(token.substring(start)));
    }

    public Vector parse(Object data) {
        this._sensorPacket = (SensorDataPacket)data;
        this._fields = super.parse(data);
        String foo = (String)this.get(4);
        StringTokenizer st = new StringTokenizer(foo.trim(), ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.toUpperCase().startsWith("T")) {
                this._fields.setElementAt(this.getDouble(token, 1), 5);
            }
            if (token.toUpperCase().startsWith("P")) {
                this._fields.setElementAt(this.getDouble(token, 1), 6);
            }
            if (token.toUpperCase().startsWith("H")) {
                this._fields.setElementAt(this.getDouble(token, 1), 7);
            }
            if (token.toUpperCase().startsWith("GFL")) {
                this._fields.setElementAt(this.getDouble(token, 3), 8);
            }
            if (!token.toUpperCase().startsWith("GFH")) continue;
            this._fields.setElementAt(this.getDouble(token, 3), 9);
        }
        return this._fields;
    }

    public Object get(int field) {
        if (field < 10) {
            return this._fields.elementAt(field);
        }
        return null;
    }

    public Object get(String fieldName) {
        String field = fieldName.trim().toUpperCase();
        if (field.equals("TEMPERATURE")) {
            return this._fields.elementAt(5);
        }
        if (field.equals("PRESSURE")) {
            return this._fields.elementAt(6);
        }
        if (field.equals("HUMIDITY")) {
            return this._fields.elementAt(7);
        }
        if (field.equals("GFLO")) {
            return this._fields.elementAt(8);
        }
        if (field.equals("GFHI")) {
            return this._fields.elementAt(9);
        }
        return super.get(fieldName);
    }
}

