/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JFrame;
import moos.operations.utils.node.BaseSettings;
import moos.operations.utils.node.EnvDataset;
import moos.operations.utils.node.GFHighSettings;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.TemperatureSettings;
import moos.operations.utils.nodeview.monitor.EnvironmentalPacketParser;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.SensorDataPacket;

public class UpdateEnvDataThread
implements Runnable {
    private Instrument _instrument;
    private Vector _dataList;
    private EnvironmentalPacketParser _parser = new EnvironmentalPacketParser();
    private JFrame _chart;
    private boolean _run = false;
    BaseSettings _base;

    public UpdateEnvDataThread(Instrument instrument, Vector dataList, JFrame chart) {
        this._instrument = instrument;
        this._dataList = dataList;
        this._chart = chart;
        this._run = this._chart.isVisible();
        EnvDataset d = (EnvDataset)((Object)this._dataList.elementAt(0));
        this._base = d.getSeriesName(0).equals(GUIConstants.TEMPERATURE) ? ((TemperatureSettings)d.getSettings()).baseSettings : ((GFHighSettings)d.getSettings()).baseSettings;
    }

    synchronized void getData() {
        try {
            SensorDataPacket dataPacket = this._instrument.acquireSample(false);
            this._parser.parse(dataPacket);
            Long t1 = (Long)this._parser.get(0);
            long t2 = t1;
            Double time = new Double(t2);
            Double temp = (Double)this._parser.get(5);
            Double humidity = (Double)this._parser.get(7);
            Double pressure = (Double)this._parser.get(6);
            Double gfHigh = (Double)this._parser.get(9);
            Double gfLow = (Double)this._parser.get(8);
            int i = 0;
            while (i < this._dataList.size()) {
                EnvDataset d = (EnvDataset)((Object)this._dataList.elementAt(i));
                if (d.getSeriesName(0).equals(GUIConstants.TEMPERATURE)) {
                    d.add(time, temp);
                }
                if (d.getSeriesName(0).equals(GUIConstants.PRESSURE)) {
                    d.add(time, pressure);
                }
                if (d.getSeriesName(0).equals(GUIConstants.HUMIDITY)) {
                    d.add(time, humidity);
                }
                if (d.getSeriesName(0).equals(GUIConstants.GFHIGH)) {
                    d.add(time, gfHigh);
                }
                if (d.getSeriesName(0).equals(GUIConstants.GFLOW)) {
                    d.add(time, gfLow);
                }
                ++i;
            }
        }
        catch (NoDataException e) {
            System.out.println("No data");
        }
        catch (RemoteException e) {
            System.out.println("RemoteException");
        }
    }

    public void run() {
        while (this._run) {
            try {
                Thread.sleep(this._base.SAMPLETIME * 1000);
                this.getData();
            }
            catch (Exception e) {
                System.out.println("UpdateEnvDataThread : exception caught " + e);
            }
        }
    }

    public void setRun(boolean value) {
        this._run = value;
    }
}

