/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import moos.operations.utils.node.EnvDataset;
import moos.operations.utils.node.GFHighSettings;
import moos.operations.utils.node.GFLowSettings;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.MessageBox;

public class SettingsPanel
extends JPanel
implements ActionListener {
    private JLabel _alarmLimits = new JLabel("Alarm Limits");
    private JLabel _minAlarmLabel = new JLabel("Minimum");
    private JLabel _maxAlarmLabel = new JLabel("Maximum");
    private JLabel _gfHighAlarm = new JLabel("GF High");
    private JTextField _minGFHighAlarm;
    private JTextField _maxGFHighAlarm;
    private JLabel _gfLowAlarm = new JLabel("GF Low");
    private JTextField _minGFLowAlarm;
    private JTextField _maxGFLowAlarm;
    private JLabel _rangeLimits = new JLabel("Range Limits");
    private JLabel _minRangeLabel = new JLabel("Minimum");
    private JLabel _maxRangeLabel = new JLabel("Maximum");
    private JLabel _gfHighRange = new JLabel("GF High");
    private JTextField _minGFHighRange;
    private JTextField _maxGFHighRange;
    private JLabel _gfLowRange = new JLabel("GF Low");
    private JTextField _minGFLowRange;
    private JTextField _maxGFLowRange;
    private JCheckBox _autoAdjustRange = new JCheckBox("Auto Adjust");
    private JCheckBox _autoSample = new JCheckBox("Auto Sample Rate");
    private JButton _decSample = new JButton("<");
    private JLabel _sampleRate;
    private JButton _incSample = new JButton(">");
    private GridBagLayout _gridBag = new GridBagLayout();
    private GridBagConstraints _constraints = new GridBagConstraints();
    private JButton _changeButton = new JButton("Change");
    private JButton _cancelButton = new JButton("Cancel");
    GFHighSettings _gfhSettings;
    GFLowSettings _gflSettings;
    String _nodeName;

    public SettingsPanel(Vector data, String nodeName) {
        this.setLayout(this._gridBag);
        this.setBackground(Color.white);
        this._nodeName = nodeName;
        this._gfhSettings = (GFHighSettings)((EnvDataset)((Object)data.elementAt(0))).getSettings();
        this._gflSettings = (GFLowSettings)((EnvDataset)((Object)data.elementAt(1))).getSettings();
        this._minGFHighAlarm = new JTextField(new Double(this._gfhSettings.MINGFHIGH_ALARM).toString(), 6);
        this._maxGFHighAlarm = new JTextField(new Double(this._gfhSettings.MAXGFHIGH_ALARM).toString(), 6);
        this._minGFLowAlarm = new JTextField(new Double(this._gflSettings.MINGFLOW_ALARM).toString(), 6);
        this._maxGFLowAlarm = new JTextField(new Double(this._gflSettings.MAXGFLOW_ALARM).toString(), 6);
        this._minGFHighRange = new JTextField(new Double(this._gfhSettings.MINGFHIGH).toString(), 6);
        this._maxGFHighRange = new JTextField(new Double(this._gfhSettings.MAXGFHIGH).toString(), 6);
        this._minGFLowRange = new JTextField(new Double(this._gflSettings.MINGFLOW).toString(), 6);
        this._maxGFLowRange = new JTextField(new Double(this._gflSettings.MAXGFLOW).toString(), 6);
        this._sampleRate = new JLabel(this._gfhSettings.baseSettings.SAMPLETIME.toString());
        JLabel heading = new JLabel("Settings");
        heading.setFont(new Font("SansSerif", 1, 14));
        heading.setForeground(Color.black);
        this.setConstraints(0, 0, 3, 1, 0, 0);
        this._gridBag.setConstraints(heading, this._constraints);
        this.add(heading);
        this.setConstraints(0, 1, 1, 1, 0, 0);
        this._alarmLimits.setForeground(Color.black);
        this._gridBag.setConstraints(this._alarmLimits, this._constraints);
        this.add(this._alarmLimits);
        this.setConstraints(1, 2, 1, 1, 0, 0);
        this._minAlarmLabel.setForeground(Color.black);
        this._gridBag.setConstraints(this._minAlarmLabel, this._constraints);
        this.add(this._minAlarmLabel);
        this.setConstraints(2, 2, 1, 1, 0, 0);
        this._maxAlarmLabel.setForeground(Color.black);
        this._gridBag.setConstraints(this._maxAlarmLabel, this._constraints);
        this.add(this._maxAlarmLabel);
        this.setConstraints(0, 3, 1, 1, 0, 0);
        this._gfHighAlarm.setForeground(Color.black);
        this._gridBag.setConstraints(this._gfHighAlarm, this._constraints);
        this.add(this._gfHighAlarm);
        this.setConstraints(1, 3, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._minGFHighAlarm, this._constraints);
        this.add(this._minGFHighAlarm);
        this.setConstraints(2, 3, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._maxGFHighAlarm, this._constraints);
        this.add(this._maxGFHighAlarm);
        this.setConstraints(0, 4, 1, 1, 0, 0);
        this._gfLowAlarm.setForeground(Color.blue);
        this._gridBag.setConstraints(this._gfLowAlarm, this._constraints);
        this.add(this._gfLowAlarm);
        this.setConstraints(1, 4, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._minGFLowAlarm, this._constraints);
        this.add(this._minGFLowAlarm);
        this.setConstraints(2, 4, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._maxGFLowAlarm, this._constraints);
        this.add(this._maxGFLowAlarm);
        JLabel blank = new JLabel("        ");
        this.setConstraints(0, 5, 3, 1, 0, 0);
        this._gridBag.setConstraints(blank, this._constraints);
        this.add(blank);
        this.setConstraints(0, 6, 1, 1, 0, 0);
        this._rangeLimits.setForeground(Color.black);
        this._gridBag.setConstraints(this._rangeLimits, this._constraints);
        this.add(this._rangeLimits);
        this.setConstraints(0, 7, 1, 1, 0, 0);
        this._autoAdjustRange.setSelected(this._gfhSettings.baseSettings.AUTOSCALING);
        this._autoAdjustRange.setBackground(Color.white);
        this._gridBag.setConstraints(this._autoAdjustRange, this._constraints);
        this.add(this._autoAdjustRange);
        this.setConstraints(1, 8, 1, 1, 0, 0);
        this._minRangeLabel.setForeground(Color.black);
        this._gridBag.setConstraints(this._minRangeLabel, this._constraints);
        this.add(this._minRangeLabel);
        this.setConstraints(2, 8, 1, 1, 0, 0);
        this._maxRangeLabel.setForeground(Color.black);
        this._gridBag.setConstraints(this._maxRangeLabel, this._constraints);
        this.add(this._maxRangeLabel);
        this.setConstraints(0, 9, 1, 1, 0, 0);
        this._gfHighRange.setForeground(Color.black);
        this._gridBag.setConstraints(this._gfHighRange, this._constraints);
        this.add(this._gfHighRange);
        this.setConstraints(1, 9, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._minGFHighRange, this._constraints);
        this.add(this._minGFHighRange);
        this.setConstraints(2, 9, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._maxGFHighRange, this._constraints);
        this.add(this._maxGFHighRange);
        this.setConstraints(0, 10, 1, 1, 0, 0);
        this._gfLowRange.setForeground(Color.blue);
        this._gridBag.setConstraints(this._gfLowRange, this._constraints);
        this.add(this._gfLowRange);
        this.setConstraints(1, 10, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._minGFLowRange, this._constraints);
        this.add(this._minGFLowRange);
        this.setConstraints(2, 10, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._maxGFLowRange, this._constraints);
        this.add(this._maxGFLowRange);
        JLabel blank2 = new JLabel("        ");
        this.setConstraints(0, 11, 3, 1, 0, 0);
        this._gridBag.setConstraints(blank2, this._constraints);
        this.add(blank2);
        this.setConstraints(0, 12, 2, 1, 0, 0);
        this._autoSample.setSelected(this._gfhSettings.baseSettings.AUTOSAMPLE);
        this._autoSample.setBackground(Color.white);
        this._gridBag.setConstraints(this._autoSample, this._constraints);
        this.add(this._autoSample);
        JPanel samplePanel = new JPanel();
        samplePanel.setLayout(new BorderLayout());
        samplePanel.setBackground(Color.white);
        samplePanel.add((Component)this._incSample, "East");
        samplePanel.add((Component)this._sampleRate, "Center");
        samplePanel.add((Component)this._decSample, "West");
        this.setConstraints(0, 13, 2, 1, 0, 0);
        this._gridBag.setConstraints(samplePanel, this._constraints);
        this.add(samplePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Color.white);
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this._changeButton);
        buttonPanel.add(this._cancelButton);
        JLabel blank3 = new JLabel("          ");
        this.setConstraints(0, 14, 3, 1, 0, 0);
        this._gridBag.setConstraints(blank3, this._constraints);
        this.add(blank3);
        this.setConstraints(0, 15, 3, 1, 0, 0);
        this._gridBag.setConstraints(buttonPanel, this._constraints);
        this.add(buttonPanel);
        this.setFieldsEditable(false);
        this._cancelButton.setEnabled(false);
        if (this._autoSample.isSelected()) {
            this._incSample.setEnabled(false);
            this._decSample.setEnabled(false);
        } else {
            this._incSample.setEnabled(true);
            this._decSample.setEnabled(true);
        }
        this._decSample.addActionListener(this);
        this._incSample.addActionListener(this);
        this._changeButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        this._autoAdjustRange.addActionListener(this);
        this._autoSample.addActionListener(this);
        this.setVisible(true);
    }

    private void setConstraints(int gridx, int gridy, int gridwidth, int gridheight, int ipadx, int ipady) {
        this._constraints.gridx = gridx;
        this._constraints.gridy = gridy;
        this._constraints.gridwidth = gridwidth;
        this._constraints.gridheight = gridheight;
        this._constraints.ipadx = ipadx;
        this._constraints.ipady = ipady;
    }

    public void setFieldsEditable(boolean value) {
        this._minGFHighAlarm.setEditable(value);
        this._maxGFHighAlarm.setEditable(value);
        this._minGFLowAlarm.setEditable(value);
        this._maxGFLowAlarm.setEditable(value);
        if (value && !this._autoAdjustRange.isSelected()) {
            this._minGFHighRange.setEditable(value);
            this._maxGFHighRange.setEditable(value);
            this._minGFLowRange.setEditable(value);
            this._maxGFLowRange.setEditable(value);
            this._minGFHighRange.setEnabled(true);
            this._maxGFHighRange.setEnabled(true);
            this._minGFLowRange.setEnabled(true);
            this._maxGFLowRange.setEnabled(true);
        } else if (!value && this._autoAdjustRange.isSelected()) {
            this._minGFHighRange.setEditable(value);
            this._maxGFHighRange.setEditable(value);
            this._minGFLowRange.setEditable(value);
            this._maxGFLowRange.setEditable(value);
            this._minGFHighRange.setEnabled(false);
            this._maxGFHighRange.setEnabled(false);
            this._minGFLowRange.setEnabled(false);
            this._maxGFLowRange.setEnabled(false);
        } else if (!value && !this._autoAdjustRange.isSelected()) {
            this._minGFHighRange.setEditable(value);
            this._maxGFHighRange.setEditable(value);
            this._minGFLowRange.setEditable(value);
            this._maxGFLowRange.setEditable(value);
            this._minGFHighRange.setEnabled(true);
            this._maxGFHighRange.setEnabled(true);
            this._minGFLowRange.setEnabled(true);
            this._maxGFLowRange.setEnabled(true);
        }
        this._decSample.setEnabled(value);
        this._incSample.setEnabled(value);
    }

    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s instanceof JButton) {
            JButton source = (JButton)e.getSource();
            if (source.getText().equals("Change")) {
                this._changeButton.setText("Save");
                this._cancelButton.setEnabled(true);
                this.setFieldsEditable(true);
            } else if (source.getText().equals("Cancel")) {
                this._minGFHighAlarm.setText(new Double(this._gfhSettings.MINGFHIGH_ALARM).toString());
                this._maxGFHighAlarm.setText(new Double(this._gfhSettings.MAXGFHIGH_ALARM).toString());
                this._minGFLowAlarm.setText(new Double(this._gflSettings.MINGFLOW_ALARM).toString());
                this._maxGFLowAlarm.setText(new Double(this._gflSettings.MAXGFLOW_ALARM).toString());
                this._minGFHighRange.setText(new Double(this._gfhSettings.MINGFHIGH).toString());
                this._maxGFHighRange.setText(new Double(this._gfhSettings.MAXGFHIGH).toString());
                this._minGFLowRange.setText(new Double(this._gflSettings.MINGFLOW).toString());
                this._maxGFLowRange.setText(new Double(this._gflSettings.MAXGFLOW).toString());
                this.setFieldsEditable(false);
                this._cancelButton.setEnabled(false);
                this._changeButton.setText("Change");
            } else if (source.getText().equals("<")) {
                int sampleRate = Integer.parseInt(this._sampleRate.getText());
                this._gfhSettings.baseSettings.SAMPLETIME = new Integer(--sampleRate);
                this._sampleRate.setText(this._gfhSettings.baseSettings.SAMPLETIME.toString());
            } else if (source.getText().equals(">")) {
                int sampleRate = Integer.parseInt(this._sampleRate.getText());
                this._gfhSettings.baseSettings.SAMPLETIME = new Integer(++sampleRate);
                this._sampleRate.setText(this._gfhSettings.baseSettings.SAMPLETIME.toString());
            } else if (this.checkFields()) {
                this._changeButton.setText("Change");
                this._cancelButton.setEnabled(false);
                this.setFieldsEditable(false);
            } else {
                MessageBox m = new MessageBox("Enter float values in all fields");
            }
        } else {
            JCheckBox cx = (JCheckBox)s;
            if (cx.getText().equals("Auto Adjust")) {
                if (cx.isSelected()) {
                    this._gfhSettings.baseSettings.AUTOSCALING = true;
                    this._gflSettings.baseSettings.AUTOSCALING = true;
                    this._minGFHighRange.setEnabled(false);
                    this._maxGFHighRange.setEnabled(false);
                    this._minGFLowRange.setEnabled(false);
                    this._maxGFLowRange.setEnabled(false);
                    if (this._changeButton.getText().equals("Save")) {
                        this._minGFHighRange.setEditable(false);
                        this._maxGFHighRange.setEditable(false);
                        this._minGFLowRange.setEditable(false);
                        this._maxGFLowRange.setEditable(false);
                    }
                } else {
                    this._gfhSettings.baseSettings.AUTOSCALING = false;
                    this._gflSettings.baseSettings.AUTOSCALING = false;
                    this._minGFHighRange.setEnabled(true);
                    this._maxGFHighRange.setEnabled(true);
                    this._minGFLowRange.setEnabled(true);
                    this._maxGFLowRange.setEnabled(true);
                    if (this._changeButton.getText().equals("Save")) {
                        this._minGFHighRange.setEditable(true);
                        this._maxGFHighRange.setEditable(true);
                        this._minGFLowRange.setEditable(true);
                        this._maxGFLowRange.setEditable(true);
                    }
                }
            } else if (cx.isSelected()) {
                this._gfhSettings.baseSettings.AUTOSAMPLE = true;
                this._incSample.setEnabled(false);
                this._decSample.setEnabled(false);
            } else {
                this._gfhSettings.baseSettings.AUTOSAMPLE = false;
                this._incSample.setEnabled(true);
                this._decSample.setEnabled(true);
            }
        }
    }

    public boolean checkFields() {
        try {
            double value1 = Double.parseDouble(this._minGFHighAlarm.getText());
            double value2 = Double.parseDouble(this._maxGFHighAlarm.getText());
            double value3 = Double.parseDouble(this._minGFLowAlarm.getText());
            double value4 = Double.parseDouble(this._maxGFLowAlarm.getText());
            double value5 = Double.parseDouble(this._minGFHighRange.getText());
            double value6 = Double.parseDouble(this._maxGFHighRange.getText());
            double value7 = Double.parseDouble(this._minGFLowRange.getText());
            double value8 = Double.parseDouble(this._maxGFLowRange.getText());
            this._gfhSettings.MINGFHIGH_ALARM = value1;
            this._gfhSettings.MAXGFHIGH_ALARM = value2;
            this._gflSettings.MINGFLOW_ALARM = value3;
            this._gflSettings.MAXGFLOW_ALARM = value4;
            this._gfhSettings.MINGFHIGH = value5;
            this._gfhSettings.MAXGFHIGH = value6;
            this._gflSettings.MINGFLOW = value7;
            this._gflSettings.MAXGFLOW = value8;
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void saveSettings() {
        HashMap<String, Serializable> set = new HashMap<String, Serializable>();
        set.put(GUIConstants.GFHIGH, this._gfhSettings);
        set.put(GUIConstants.GFLOW, this._gflSettings);
        try {
            FileOutputStream f = new FileOutputStream(this._nodeName + "_GF.set");
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(set);
            s.flush();
        }
        catch (FileNotFoundException exception) {
            System.out.println("Could not create settings file");
        }
        catch (IOException exception) {
            System.out.println("IOException");
        }
    }
}

