/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Vector;
import moos.deployed.RangeException;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.DuplicateIdException;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.Port;
import org.mbari.isi.interfaces.PortNotFound;
import org.mbari.isi.interfaces.PortOccupiedException;
import org.mbari.isi.interfaces.RemoteSerialPort;
import org.mbari.isi.interfaces.SensorDataPacket;

public class PortProxy {
    private Port port = null;
    private Node node = null;
    private String _portName;

    public PortProxy(Port p, Node n) {
        this.port = p;
        this.node = n;
        this._portName = new String(p.getName());
    }

    public void refreshPort() {
        try {
            String name = null;
            Port[] portList = this.node.getPorts();
            int i = 0;
            while (i < portList.length) {
                name = new String(portList[i].getName());
                if (name.equals(this._portName)) {
                    this.port = portList[i];
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            System.out.println("Caught Exception" + e);
        }
    }

    public boolean getActive() {
        return this.port.hasService();
    }

    public String getName() {
        return new String(this.port.getName());
    }

    public String getServiceMnemonic() {
        try {
            return new String(this.port.getServiceMnemonic());
        }
        catch (DeviceNotFound d) {
            return null;
        }
    }

    public String getDeviceID() {
        try {
            return new Long(this.port.getDeviceID()).toString();
        }
        catch (DeviceNotFound d) {
            return null;
        }
    }

    public String getDeviceStatus() {
        try {
            long deviceID = this.port.getDeviceID();
            Device d = this.node.getDevice(deviceID);
            int status = d.getStatus();
            switch (status) {
                case 0: {
                    return new String("OK");
                }
                case 1: {
                    return new String("ERROR");
                }
                case 2: {
                    return new String("INITIAL");
                }
                case 3: {
                    return new String("SHUTDOWN");
                }
                case 4: {
                    return new String("SUSPEND");
                }
                case 5: {
                    return new String("SAMPLING");
                }
                case -1: {
                    return new String("UNKNOWN");
                }
            }
            return new String("UNKNOWN");
        }
        catch (Exception n) {
            return null;
        }
    }

    public String suspendService() {
        try {
            this.node.suspendService(this.port.getName());
            System.out.println("suspend  port : no error");
            return null;
        }
        catch (PortNotFound p) {
            return "Port not found";
        }
        catch (DeviceNotFound d) {
            return "Device not found";
        }
        catch (RemoteException e) {
            return "Remote Exception";
        }
    }

    public String scanPort() {
        try {
            this.node.scanPort(this.port.getName());
            System.out.println("Scanned port : no error");
            return null;
        }
        catch (DeviceNotFound d) {
            return "Device not found";
        }
        catch (PortNotFound p) {
            return "Port not found";
        }
        catch (PortOccupiedException o) {
            return "Port occupied";
        }
        catch (RemoteException e) {
            return "Remote Exception";
        }
        catch (DuplicateIdException e) {
            return "Duplicate Id Exception";
        }
        catch (IOException e) {
            return "IOException";
        }
    }

    public String resumeService() {
        try {
            this.node.resumeService(this.port.getName());
            System.out.println("resumed  port : no error");
            return null;
        }
        catch (PortNotFound d) {
            return "Port not found";
        }
        catch (DeviceNotFound d) {
            return "Device not found";
        }
        catch (RemoteException e) {
            return "Remote Exception";
        }
    }

    public String shutdownDeviceService() {
        try {
            this.node.shutdownDeviceService(this.port.getName());
            System.out.println("shut down port: no error");
            return null;
        }
        catch (PortNotFound d) {
            return "Port not found";
        }
        catch (DeviceNotFound d) {
            return "Device not found";
        }
        catch (RemoteException e) {
            return "Remote Exception";
        }
    }

    public String annotateIntrument(String s) {
        try {
            long deviceID = this.port.getDeviceID();
            Device d = this.node.getDevice(deviceID);
            if (d instanceof Instrument) {
                Instrument ins = (Instrument)d;
                ins.annotate(s.getBytes());
                return null;
            }
            return "Instrument not found";
        }
        catch (DeviceNotFound d) {
            return "Device not Found";
        }
        catch (RemoteException e) {
            return "Remote Exception";
        }
    }

    public Node getNode() {
        return this.node;
    }

    public Object getProperties() {
        try {
            long deviceID = this.port.getDeviceID();
            Device d = this.node.getDevice(deviceID);
            if (d instanceof Instrument) {
                Instrument ins = (Instrument)d;
                Vector properties = ins.getProperties();
                return properties;
            }
            return "Instrument Error";
        }
        catch (DeviceNotFound d) {
            return "Device not Found";
        }
        catch (RemoteException e) {
            return "Remote Exception";
        }
    }

    public Object getSample() {
        try {
            long deviceID = this.port.getDeviceID();
            Device d = this.node.getDevice(deviceID);
            if (d instanceof Instrument) {
                Instrument ins = (Instrument)d;
                SensorDataPacket sampleData = ins.acquireSample(true);
                return sampleData;
            }
            return "Instrument Error";
        }
        catch (NoDataException d) {
            return "No Data";
        }
        catch (DeviceNotFound d) {
            return "Device not Found";
        }
        catch (RemoteException e) {
            return "Remote Exception";
        }
    }

    public Object getRemoteSerialPort() {
        String siamHome = System.getProperty("siam_home");
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(siamHome + "/properties/UIProperties.properties"));
        }
        catch (IOException e) {
            System.out.println("Exception caught" + e);
        }
        String value = prop.getProperty("consoleTimeOut");
        int t = Integer.parseInt(value);
        System.out.println("in getremote serial port");
        try {
            RemoteSerialPort rPort = this.node.getRemoteSerialPort(this.port.getName(), t * 1000 + 10000);
            return rPort;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "Remote Exception";
        }
        catch (UnknownHostException e) {
            return "UnknownHostException ";
        }
        catch (PortNotFound e) {
            return "Port Not Found";
        }
        catch (PortOccupiedException e) {
            return "Port Occupied";
        }
        catch (RangeException e) {
            return "Range Exception";
        }
        catch (IOException e) {
            return "IOException";
        }
    }
}

