/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.sql.Time;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import moos.operations.utils.node.AnnotateFrame;
import moos.operations.utils.node.Console;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.PortProxy;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.Port;
import org.mbari.isi.interfaces.RemoteSerialPort;
import org.mbari.isi.interfaces.SensorDataPacket;

public class Operations
extends JFrame
implements ActionListener,
MouseListener,
Runnable,
KeyListener {
    private JPanel dataPanel = new JPanel();
    private JLabel portNameLabel = new JLabel("Port Name");
    private JLabel serviceNameLabel = new JLabel("Service Name");
    private JLabel deviceIdLabel = new JLabel("Device ID");
    private JLabel deviceStatusLabel = new JLabel("Device Status");
    private JLabel portName = new JLabel();
    private JLabel serviceName = new JLabel();
    private JLabel deviceID = new JLabel();
    private JLabel deviceStatus = new JLabel();
    private JLabel _timeLabel = new JLabel("Last Update");
    private JLabel _lastUpdateTimeLabel = new JLabel();
    private Time _lastUpdateTime = new Time(System.currentTimeMillis());
    private JButton suspendButton = new JButton("Suspend");
    private JButton resumeButton = new JButton("Resume");
    private JButton scanButton = new JButton("Scan");
    private JButton propertiesButton = new JButton("View Properties");
    private JButton sampleButton = new JButton("Sample Port");
    private JButton shutdownButton = new JButton("Shutdown Port");
    private JButton annotateButton = new JButton("Annotate");
    private JButton _consoleButton = new JButton("Open Console");
    private JButton exitButton = new JButton("Close");
    private JPanel _closeButtonPanel = new JPanel();
    private JPanel propertiesPanel = new JPanel();
    private JTable propertiesTable = null;
    private Vector _colName = new Vector();
    private JButton editupdateButton = new JButton("Edit");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel editCancelPanel = new JPanel();
    private Vector childWindows = new Vector();
    Vector portData = new Vector();
    private JTextField errors = new JTextField("---- Errors to be displayed here ------");
    private JPanel samplePanel = new JPanel();
    private JTextArea sampleData = new JTextArea();
    private JPopupMenu popUp = new JPopupMenu();
    private JMenuItem copyMenu = new JMenuItem("Copy");
    private JLabel timeLabel = new JLabel("Sample Time");
    private JLabel timeStamp = new JLabel();
    private String propertiesPanelPosition = null;
    private String samplePanelPosition = null;
    private PortProxy port;
    private boolean status = false;
    private Thread _runner = null;
    private Integer _updateFrequency = new Integer(5);
    private JLabel _updateFrequencyLabel = new JLabel("5");
    private JButton _incFrequencyButton = new JButton(">");
    private JButton _decFrequencyButton = new JButton("<");
    private JPanel _frequencyUpdatePanel = new JPanel();
    private JLabel _frequencyLabel = new JLabel("Refresh Freq");
    GridBagLayout _gridBag = new GridBagLayout();
    GridBagConstraints _constraints = new GridBagConstraints();
    GridBagLayout _propertiesGridBag = new GridBagLayout();
    JScrollPane propertiesScrollPane = null;
    JScrollPane sampleScrollPane = null;

    public Operations(Port p, Node n) {
        Insets inset;
        try {
            this.setTitle("Port view of " + new String(p.getName()) + " on node " + new String(n.getName()));
        }
        catch (RemoteException e) {
            this.setTitle("Port View of " + new String(p.getName()));
        }
        this.port = new PortProxy(p, n);
        this.status = this.port.getActive();
        this.propertiesPanel.setLayout(this._propertiesGridBag);
        this.sampleScrollPane = new JScrollPane(this.samplePanel);
        this._colName.add("KEY");
        this._colName.add("VALUE");
        this.editCancelPanel.setLayout(new FlowLayout());
        ((Component)this).setSize(610, 320);
        this.getContentPane().setLayout(this._gridBag);
        this.dataPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagLayout dataGrid = new GridBagLayout();
        this.dataPanel.setLayout(dataGrid);
        this._timeLabel.setForeground(GUIConstants.BLACK);
        this._timeLabel.setFont(GUIConstants.FONT);
        this._lastUpdateTimeLabel.setForeground(GUIConstants.BLUE);
        this._lastUpdateTimeLabel.setFont(GUIConstants.FONT);
        this._decFrequencyButton.setForeground(GUIConstants.BLACK);
        this._decFrequencyButton.addActionListener(this);
        this._decFrequencyButton.addKeyListener(this);
        this._decFrequencyButton.setFont(new Font("SansSerif", 0, 10));
        this._updateFrequencyLabel.setForeground(GUIConstants.BLUE);
        this._updateFrequencyLabel.setHorizontalAlignment(0);
        this._updateFrequencyLabel.setFont(new Font("SansSerif", 0, 10));
        this._incFrequencyButton.setForeground(GUIConstants.BLACK);
        this._incFrequencyButton.addActionListener(this);
        this._incFrequencyButton.addKeyListener(this);
        this._incFrequencyButton.setFont(new Font("SansSerif", 0, 10));
        this._frequencyUpdatePanel.setLayout(new FlowLayout());
        this._frequencyUpdatePanel.add(this._decFrequencyButton);
        this._frequencyUpdatePanel.add(this._updateFrequencyLabel);
        this._frequencyUpdatePanel.add(this._incFrequencyButton);
        this._frequencyLabel.setForeground(GUIConstants.BLACK);
        this._frequencyLabel.setFont(GUIConstants.FONT);
        this.portNameLabel.setForeground(GUIConstants.BLACK);
        this.portNameLabel.setFont(GUIConstants.FONT);
        this.portName.setForeground(GUIConstants.BLUE);
        this.portName.setFont(GUIConstants.FONT);
        this.serviceNameLabel.setFont(GUIConstants.FONT);
        this.serviceNameLabel.setForeground(GUIConstants.BLACK);
        this.serviceName.setForeground(GUIConstants.BLUE);
        this.serviceName.setFont(GUIConstants.FONT);
        this.deviceIdLabel.setFont(GUIConstants.FONT);
        this.deviceIdLabel.setForeground(GUIConstants.BLACK);
        this.deviceID.setForeground(GUIConstants.BLUE);
        this.deviceID.setFont(GUIConstants.FONT);
        this.deviceStatusLabel.setFont(GUIConstants.FONT);
        this.deviceStatusLabel.setForeground(GUIConstants.BLACK);
        this.deviceStatus.setForeground(GUIConstants.BLUE);
        this.deviceStatus.setFont(GUIConstants.FONT);
        this._constraints.insets = inset = new Insets(10, 5, 10, 5);
        this._constraints.fill = 2;
        this._constraints.weightx = 0.5;
        this._constraints.weighty = 0.5;
        this.setConstraints(0, 0, 1, 1, 0, 0);
        dataGrid.setConstraints(this._timeLabel, this._constraints);
        this.dataPanel.add(this._timeLabel);
        this.setConstraints(1, 0, 1, 1, 0, 0);
        dataGrid.setConstraints(this._lastUpdateTimeLabel, this._constraints);
        this.dataPanel.add(this._lastUpdateTimeLabel);
        this.setConstraints(2, 0, 1, 1, 0, 0);
        dataGrid.setConstraints(this._frequencyLabel, this._constraints);
        this.dataPanel.add(this._frequencyLabel);
        this._constraints.weightx = 0.5;
        this._constraints.weighty = 1.0;
        this.setConstraints(3, 0, 2, 1, 0, 0);
        dataGrid.setConstraints(this._frequencyUpdatePanel, this._constraints);
        this.dataPanel.add(this._frequencyUpdatePanel);
        this.setConstraints(0, 1, 1, 1, 0, 0);
        dataGrid.setConstraints(this.portNameLabel, this._constraints);
        this.dataPanel.add(this.portNameLabel);
        this.setConstraints(1, 1, 1, 1, 0, 0);
        dataGrid.setConstraints(this.portName, this._constraints);
        this.dataPanel.add(this.portName);
        this.setConstraints(2, 1, 1, 1, 0, 0);
        dataGrid.setConstraints(this.serviceNameLabel, this._constraints);
        this.dataPanel.add(this.serviceNameLabel);
        this.setConstraints(3, 1, 1, 1, 0, 0);
        dataGrid.setConstraints(this.serviceName, this._constraints);
        this.dataPanel.add(this.serviceName);
        this.setConstraints(0, 2, 1, 1, 0, 0);
        dataGrid.setConstraints(this.deviceIdLabel, this._constraints);
        this.dataPanel.add(this.deviceIdLabel);
        this.setConstraints(1, 2, 1, 1, 0, 0);
        dataGrid.setConstraints(this.deviceID, this._constraints);
        this.dataPanel.add(this.deviceID);
        this.setConstraints(2, 2, 1, 1, 0, 0);
        dataGrid.setConstraints(this.deviceStatusLabel, this._constraints);
        this.dataPanel.add(this.deviceStatusLabel);
        this.setConstraints(3, 2, 1, 1, 0, 0);
        dataGrid.setConstraints(this.deviceStatus, this._constraints);
        this.dataPanel.add(this.deviceStatus);
        this.setConstraints(0, 0, 4, 3, 240, 85);
        this._gridBag.setConstraints(this.dataPanel, this._constraints);
        this.getContentPane().add(this.dataPanel);
        this._constraints.weightx = 0.0;
        this._constraints.weighty = 0.0;
        this.setConstraints(4, 0, 1, 1, 0, 0);
        this._gridBag.setConstraints(this.propertiesButton, this._constraints);
        this.propertiesButton.addActionListener(this);
        this.propertiesButton.addKeyListener(this);
        this.getContentPane().add(this.propertiesButton);
        this.setConstraints(4, 1, 1, 1, 0, 0);
        this._gridBag.setConstraints(this.sampleButton, this._constraints);
        this.getContentPane().add(this.sampleButton);
        this.sampleButton.addActionListener(this);
        this.sampleButton.addKeyListener(this);
        this.setConstraints(4, 2, 1, 1, 0, 0);
        this._gridBag.setConstraints(this._consoleButton, this._constraints);
        this.getContentPane().add(this._consoleButton);
        this._consoleButton.addActionListener(this);
        this._consoleButton.addKeyListener(this);
        this.setConstraints(0, 3, 1, 1, 0, 0);
        this._gridBag.setConstraints(this.scanButton, this._constraints);
        this.getContentPane().add(this.scanButton);
        this.scanButton.addActionListener(this);
        this.scanButton.addKeyListener(this);
        this.setConstraints(1, 3, 1, 1, 0, 0);
        this._gridBag.setConstraints(this.suspendButton, this._constraints);
        this.getContentPane().add(this.suspendButton);
        this.suspendButton.addActionListener(this);
        this.suspendButton.addKeyListener(this);
        this.setConstraints(2, 3, 1, 1, 0, 0);
        this._gridBag.setConstraints(this.resumeButton, this._constraints);
        this.getContentPane().add(this.resumeButton);
        this.resumeButton.addActionListener(this);
        this.resumeButton.addKeyListener(this);
        this.setConstraints(3, 3, 1, 1, 0, 0);
        this._gridBag.setConstraints(this.shutdownButton, this._constraints);
        this.getContentPane().add(this.shutdownButton);
        this.shutdownButton.addActionListener(this);
        this.shutdownButton.addKeyListener(this);
        this.setConstraints(4, 3, 1, 1, 0, 0);
        this._gridBag.setConstraints(this.annotateButton, this._constraints);
        this.getContentPane().add(this.annotateButton);
        this.annotateButton.addActionListener(this);
        this.annotateButton.addKeyListener(this);
        this.setConstraints(0, 4, 5, 1, 0, 5);
        this._gridBag.setConstraints(this.errors, this._constraints);
        this.getContentPane().add(this.errors);
        this.errors.setForeground(Color.red);
        this.errors.setBackground(Color.lightGray.brighter());
        this.errors.setEditable(false);
        this._closeButtonPanel.add((Component)this.exitButton, "Center");
        this.setConstraints(0, 5, 5, 1, 0, 0);
        this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
        this.getContentPane().add(this._closeButtonPanel);
        this.exitButton.addActionListener(this);
        this.exitButton.addKeyListener(this);
        this.editupdateButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.show();
        this.refresh();
        this.start();
    }

    public void start() {
        if (this._runner == null) {
            this._runner = new Thread(this);
            this._runner.start();
        }
    }

    public void run() {
        while (this.isVisible()) {
            this.refresh();
            try {
                Thread.sleep(this._updateFrequency * 1000);
            }
            catch (Exception e) {
                System.out.println("Class Operations  : Error while sleeping");
            }
        }
    }

    private void refresh() {
        this.port.refreshPort();
        this.portName.setText(this.port.getName());
        this._lastUpdateTime.setTime(System.currentTimeMillis());
        this._lastUpdateTimeLabel.setText(this._lastUpdateTime.toString());
        this.status = this.port.getActive();
        if (this.status) {
            this.serviceName.setText(this.port.getServiceMnemonic());
            this.deviceID.setText(this.port.getDeviceID());
            this.deviceStatus.setText(this.port.getDeviceStatus());
            if (!this.port.getDeviceStatus().equals("SUSPEND")) {
                this.resumeButton.setEnabled(false);
                this.suspendButton.setEnabled(true);
            } else {
                this.suspendButton.setEnabled(false);
                this.resumeButton.setEnabled(true);
            }
            this.propertiesButton.setEnabled(true);
            this.sampleButton.setEnabled(true);
            this.annotateButton.setEnabled(true);
            this.shutdownButton.setEnabled(true);
        } else {
            this.serviceName.setText("-");
            this.deviceID.setText("-");
            this.deviceStatus.setText("-");
            this.suspendButton.setEnabled(false);
            this.resumeButton.setEnabled(false);
            this.propertiesButton.setEnabled(false);
            this.sampleButton.setEnabled(false);
            this.annotateButton.setEnabled(false);
            this.shutdownButton.setEnabled(false);
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent event) {
        JButton source = (JButton)event.getSource();
        if (source.getText().equals("Close")) {
            int i = 0;
            while (i < this.childWindows.size()) {
                ((JFrame)this.childWindows.get(i)).dispose();
                ++i;
            }
            this.dispose();
        } else if (source.getText().equals("View Properties")) {
            Object o = this.port.getProperties();
            if (o instanceof String) {
                this.errors.setText((String)o);
            } else {
                this.getContentPane().remove(this._closeButtonPanel);
                this.propertiesPanel.setBorder(BorderFactory.createLineBorder(Color.black));
                Vector properties = (Vector)o;
                Vector rowData = new Vector();
                int i = 0;
                while (i < properties.size()) {
                    Vector<String> row = new Vector<String>();
                    byte[] b = (byte[])properties.get(i);
                    StringTokenizer keyValue = new StringTokenizer(new String(b), "=");
                    String key = keyValue.nextToken();
                    String value = keyValue.nextToken();
                    row.add(key);
                    row.add(value);
                    rowData.add(row);
                    ++i;
                }
                this.propertiesTable = new JTable(rowData, this._colName);
                this.propertiesScrollPane = new JScrollPane(this.propertiesTable);
                if (this.sampleButton.getText().equals("Sample Port")) {
                    ((Component)this).setSize(this.getWidth(), 520);
                    this.setConstraints(0, 6, 5, 1, 0, 0);
                    this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                    this.getContentPane().add(this._closeButtonPanel);
                    this.setConstraints(0, 5, 5, 1, 0, 0);
                    this._gridBag.setConstraints(this.propertiesPanel, this._constraints);
                    this.getContentPane().add(this.propertiesPanel);
                    this.propertiesPanelPosition = "Top";
                } else {
                    ((Component)this).setSize(this.getWidth(), 710);
                    System.out.println("adding properties scroll panel");
                    this.setConstraints(0, 6, 5, 1, 0, 0);
                    this._gridBag.setConstraints(this.propertiesPanel, this._constraints);
                    this.getContentPane().add(this.propertiesPanel);
                    this.setConstraints(0, 7, 5, 1, 0, 0);
                    this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                    this.getContentPane().add(this._closeButtonPanel);
                    this.propertiesPanelPosition = "Bottom";
                }
                this.cancelButton.setEnabled(false);
                this.setConstraints(0, 0, 1, 1, 500, 80);
                this._propertiesGridBag.setConstraints(this.propertiesScrollPane, this._constraints);
                this.propertiesPanel.add(this.propertiesScrollPane);
                this.editCancelPanel.add(this.editupdateButton);
                this.editCancelPanel.add(this.cancelButton);
                this.setConstraints(0, 1, 1, 1, 0, 0);
                this._propertiesGridBag.setConstraints(this.editCancelPanel, this._constraints);
                this.propertiesPanel.add(this.editCancelPanel);
                this.propertiesButton.setText("Close Properties");
                this.propertiesButton.setForeground(Color.red.darker().darker());
                ((Component)this).setVisible(true);
                this.repaint();
            }
        } else if (source.getText().equals("Close Properties")) {
            this.propertiesPanel.remove(this.propertiesScrollPane);
            this.propertiesPanel.remove(this.editCancelPanel);
            this.getContentPane().remove(this.propertiesPanel);
            this.getContentPane().remove(this._closeButtonPanel);
            if (this.sampleButton.getText().equals("Sample Port")) {
                ((Component)this).setSize(this.getWidth(), 320);
                this.setConstraints(0, 5, 5, 1, 0, 0);
                this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                this.getContentPane().add(this._closeButtonPanel);
            } else {
                this.setConstraints(0, 6, 5, 1, 0, 0);
                this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                this.getContentPane().add(this._closeButtonPanel);
                ((Component)this).setSize(this.getWidth(), 520);
                if (!this.samplePanelPosition.equals("Top")) {
                    this.getContentPane().remove(this.sampleScrollPane);
                    this.setConstraints(0, 5, 5, 1, 250, 150);
                    this._gridBag.setConstraints(this.sampleScrollPane, this._constraints);
                    this.getContentPane().add(this.sampleScrollPane);
                    this.samplePanelPosition = "Top";
                }
            }
            this.propertiesButton.setText("View Properties");
            this.propertiesButton.setForeground(Color.black);
            this.propertiesPanelPosition = null;
            ((Component)this).setVisible(true);
            this.repaint();
        } else if (source.getText().equals("Sample Port")) {
            Object sample = this.port.getSample();
            if (sample instanceof String) {
                this.errors.setText((String)sample);
            } else {
                this.getContentPane().remove(this._closeButtonPanel);
                if (this.propertiesButton.getText().equals("View Properties")) {
                    ((Component)this).setSize(this.getWidth(), 520);
                    this.setConstraints(0, 6, 5, 1, 0, 0);
                    this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                    this.getContentPane().add(this._closeButtonPanel);
                    this.setConstraints(0, 5, 5, 1, 250, 150);
                    this._gridBag.setConstraints(this.sampleScrollPane, this._constraints);
                    this.getContentPane().add(this.sampleScrollPane);
                    this.samplePanelPosition = "Top";
                } else {
                    ((Component)this).setSize(this.getWidth(), 710);
                    this.setConstraints(0, 6, 5, 1, 250, 150);
                    this._gridBag.setConstraints(this.sampleScrollPane, this._constraints);
                    this.getContentPane().add(this.sampleScrollPane);
                    this.setConstraints(0, 7, 5, 1, 0, 0);
                    this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                    this.getContentPane().add(this._closeButtonPanel);
                    this.samplePanelPosition = "Bottom";
                }
                this.samplePanel.setBorder(BorderFactory.createLineBorder(Color.black));
                this.samplePanel.setLayout(null);
                this.sampleData.setBounds(5, 30, 560, 110);
                this.sampleData.setLineWrap(true);
                this.sampleData.setText("Sampled data to be displayed here");
                this.sampleData.addMouseListener(this);
                this.sampleData.setText(((SensorDataPacket)sample).toString());
                this.timeLabel.setBounds(5, 5, 100, 20);
                this.timeStamp.setBounds(120, 5, 250, 20);
                this.timeStamp.setText(new Date(System.currentTimeMillis()).toString());
                this.popUp.add(this.copyMenu);
                this.samplePanel.add(this.timeLabel);
                this.samplePanel.add(this.timeStamp);
                this.samplePanel.add(this.sampleData);
                this.sampleButton.setText("Close Sample");
                this.sampleButton.setForeground(Color.red.darker().darker());
                this.samplePanel.repaint();
                ((Component)this).setVisible(true);
                this.repaint();
            }
        } else if (source.getText().equals("Close Sample")) {
            this.getContentPane().remove(this._closeButtonPanel);
            this.getContentPane().remove(this.sampleScrollPane);
            if (this.propertiesButton.getText().equals("View Properties")) {
                ((Component)this).setSize(this.getWidth(), 320);
                this.setConstraints(0, 5, 5, 1, 0, 0);
                this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                this.getContentPane().add(this._closeButtonPanel);
            } else {
                ((Component)this).setSize(this.getWidth(), 520);
                if (!this.propertiesPanelPosition.equals("Top")) {
                    this.getContentPane().remove(this.propertiesPanel);
                    this.setConstraints(0, 5, 5, 1, 0, 0);
                    this._gridBag.setConstraints(this.propertiesPanel, this._constraints);
                    this.getContentPane().add(this.propertiesPanel);
                    this.propertiesPanelPosition = "Top";
                }
                this.setConstraints(0, 6, 5, 1, 0, 0);
                this._gridBag.setConstraints(this._closeButtonPanel, this._constraints);
                this.getContentPane().add(this._closeButtonPanel);
                System.out.println("adding exitbutton");
            }
            this.sampleButton.setText("Sample Port");
            this.sampleButton.setForeground(Color.black);
            this.samplePanelPosition = null;
            ((Component)this).setVisible(true);
            this.repaint();
        } else if (source.getText().equals("Cancel")) {
            this.editupdateButton.setText("Edit");
            this.cancelButton.setEnabled(false);
        } else if (source.getText().equals("Edit")) {
            this.editupdateButton.setText("Update");
            this.cancelButton.setEnabled(true);
        } else if (source.getText().equals("Update")) {
            this.editupdateButton.setText("Edit");
            this.cancelButton.setEnabled(false);
        } else if (source.getText().equals("Scan")) {
            String error = this.port.scanPort();
            if (error != null) {
                this.errors.setText(error);
            }
            this.refresh();
        } else if (source.getText().equals("Suspend")) {
            System.out.println("CALLING suspend port");
            String error = this.port.suspendService();
            if (error != null) {
                this.errors.setText(error);
            }
            this.refresh();
        } else if (source.getText().equals("Resume")) {
            System.out.println("CALLING resume port");
            String error = this.port.resumeService();
            if (error != null) {
                this.errors.setText(error);
            }
            this.refresh();
        } else if (source.getText().equals("Shutdown Port")) {
            String error = this.port.shutdownDeviceService();
            this.refresh();
            System.out.println(" status of the node " + this.port.getActive());
            if (error != null) {
                this.errors.setText(error);
            }
            this.refresh();
        } else if (source.getText().equals("Annotate")) {
            AnnotateFrame a = new AnnotateFrame(this.port, this);
            this.childWindows.add(a);
        } else if (source.getText().equals("Open Console")) {
            String error = null;
            if (this.port.getActive()) {
                error = this.port.suspendService();
            }
            if (error == null) {
                Object result = this.port.getRemoteSerialPort();
                if (result instanceof String) {
                    this.errors.setText((String)result);
                } else {
                    Console c = new Console(this.port, this, (RemoteSerialPort)result);
                    this.childWindows.add(c);
                }
            } else {
                this.errors.setText("Wasn't able to suspend service :" + error);
            }
        } else if (source.getText().equals("<")) {
            int freq = Integer.parseInt(this._updateFrequencyLabel.getText());
            this._updateFrequency = freq >= 6 ? new Integer(freq - 5) : new Integer(1);
            this._updateFrequencyLabel.setText(this._updateFrequency.toString());
        } else if (source.getText().equals(">")) {
            int freq = Integer.parseInt(this._updateFrequencyLabel.getText());
            this._updateFrequency = new Integer(freq + 5);
            this._updateFrequencyLabel.setText(this._updateFrequency.toString());
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (500 == 4) {
            this.popUp.show(this.sampleData, event.getX(), event.getY());
        }
    }

    public void setErrorMessage(String error) {
        this.errors.setText(error);
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    private void setConstraints(int gridx, int gridy, int gridwidth, int gridheight, int ipadx, int ipady) {
        this._constraints.gridx = gridx;
        this._constraints.gridy = gridy;
        this._constraints.gridwidth = gridwidth;
        this._constraints.gridheight = gridheight;
        this._constraints.ipadx = ipadx;
        this._constraints.ipady = ipady;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getKeyChar() == '\n') {
            ((JButton)event.getSource()).doClick();
        }
    }
}

