/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import moos.operations.utils.node.GUIConstants;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.Port;

public class NodeProxy {
    private Node node = null;
    private String nodeUrl;
    private Port[] portList = null;
    private Vector _activePortList = new Vector();
    String _view = null;
    private boolean _gotNode = false;

    public NodeProxy(String nodeName, String view) {
        this.nodeUrl = "rmi://" + nodeName + "/node";
        this.node = this.getNodeService();
        if (this.node != null) {
            this.portList = this.getPorts();
            this._gotNode = true;
        }
        this._view = view;
    }

    public boolean gotNode() {
        return this._gotNode;
    }

    public Node getNodeService() {
        Node nodeService = null;
        this.setSecurityManager();
        try {
            System.out.println("Looking for node service at " + this.nodeUrl);
            nodeService = (Node)Naming.lookup(this.nodeUrl);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + this.nodeUrl + "\"");
            return null;
        }
        return nodeService;
    }

    public Node getNode() {
        return this.node;
    }

    public void setSecurityManager() {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
        }
        catch (Exception e) {
            System.err.println("Exception caught " + e);
        }
    }

    public Port[] getPorts() {
        try {
            this.portList = this.node.getPorts();
            return this.portList;
        }
        catch (Exception e) {
            System.err.println("Exception caught " + e);
            return null;
        }
    }

    private void refreshPortList() {
        try {
            this.portList = this.node.getPorts();
        }
        catch (RemoteException e) {
            System.out.println("Caught Exception" + e);
        }
    }

    public Port getPort(int i) {
        this.refreshPortList();
        this.refreshActivePortList();
        if (this._view.equals(GUIConstants.ALLPORTS)) {
            return this.portList[i];
        }
        return (Port)this._activePortList.elementAt(i);
    }

    public int getNoPorts() {
        this.refreshPortList();
        return this.portList.length;
    }

    public String getPortName(int portIndex) {
        this.refreshPortList();
        this.refreshActivePortList();
        if (this._view.equals(GUIConstants.ALLPORTS)) {
            return new String(this.portList[portIndex].getName());
        }
        return new String(((Port)this._activePortList.elementAt(portIndex)).getName());
    }

    public String getServiceMnemonic(int portIndex) {
        this.refreshPortList();
        this.refreshActivePortList();
        try {
            if (this._view.equals(GUIConstants.ALLPORTS)) {
                return new String(this.portList[portIndex].getServiceMnemonic());
            }
            return new String(((Port)this._activePortList.elementAt(portIndex)).getServiceMnemonic());
        }
        catch (DeviceNotFound d) {
            return null;
        }
    }

    public String getDeviceID(int portIndex) {
        this.refreshPortList();
        this.refreshActivePortList();
        try {
            if (this._view.equals(GUIConstants.ALLPORTS)) {
                return new Long(this.portList[portIndex].getDeviceID()).toString();
            }
            return new Long(((Port)this._activePortList.elementAt(portIndex)).getDeviceID()).toString();
        }
        catch (DeviceNotFound d) {
            return null;
        }
    }

    public String getDeviceStatus(int portIndex) {
        this.refreshPortList();
        this.refreshActivePortList();
        try {
            long deviceID = this._view.equals(GUIConstants.ALLPORTS) ? this.portList[portIndex].getDeviceID() : ((Port)this._activePortList.elementAt(portIndex)).getDeviceID();
            Device d = this.node.getDevice(deviceID);
            int status = d.getStatus();
            switch (status) {
                case 0: {
                    return new String("OK");
                }
                case 1: {
                    return new String("ERROR");
                }
                case 2: {
                    return new String("INITIAL");
                }
                case 3: {
                    return new String("SHUTDOWN");
                }
                case 4: {
                    return new String("SUSPEND");
                }
                case 5: {
                    return new String("SAMPLING");
                }
                case -1: {
                    return new String("UNKNOWN");
                }
            }
            return new String("UNKNOWN");
        }
        catch (Exception n) {
            return null;
        }
    }

    public void refreshActivePortList() {
        this._activePortList.removeAllElements();
        int i = 0;
        while (i < this.portList.length) {
            if (this.portList[i].hasService()) {
                this._activePortList.add(this.portList[i]);
            }
            ++i;
        }
    }

    public Vector getActivePorts() {
        this.refreshActivePortList();
        return this._activePortList;
    }

    public int getActiveNoPorts() {
        return this._activePortList.size();
    }

    public void setView(String v) {
        this._view = v;
    }
}

