/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.lang.reflect.Array;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import moos.operations.utils.node.InstrumentPowerObject;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.PowerSwitch;

public class NodePowerObject {
    private Vector _instrumentList = new Vector();
    String _powerStatus = null;
    Node _node = null;
    String _name = null;
    private PowerSwitch[] _powerSwitches = null;

    public NodePowerObject(String powerStatus, String name) {
        this._name = name;
        this._node = this.getNodeService();
        if (this._node != null) {
            try {
                this._powerSwitches = this._node.getPowerSwitches();
            }
            catch (RemoteException e) {
                System.out.println("exception caught" + e + "could not get powerSwitches");
            }
            System.out.println("number of power switches " + Array.getLength(this._powerSwitches));
            this.addToList();
            this._powerStatus = powerStatus;
        }
    }

    public void addToList() {
        int s = Array.getLength(this._powerSwitches);
        int i = 0;
        while (i < s) {
            Instrument ins = null;
            try {
                long deviceID = this._powerSwitches[i].getSwitchedDeviceID();
                ins = (Instrument)this._node.getDevice(deviceID);
            }
            catch (DeviceNotFound d) {
                System.out.println("Device not found");
            }
            catch (RemoteException e) {
                System.out.println("Remote Exception");
            }
            InstrumentPowerObject o = new InstrumentPowerObject("ON", this._powerSwitches[i], ins);
            this._instrumentList.add(o);
            ++i;
        }
    }

    PowerSwitch[] getPowerSwitches() {
        return this._powerSwitches;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name + " " + this._powerStatus;
    }

    public void addInstrument(InstrumentPowerObject ins) {
        this._instrumentList.add(ins);
    }

    public String getPowerStatus() {
        return this._powerStatus;
    }

    public String getPowerStatus(String instrumentName) {
        int i = 0;
        while (i < this._instrumentList.size()) {
            if (((InstrumentPowerObject)this._instrumentList.elementAt(i)).getName().equals(instrumentName)) {
                return ((InstrumentPowerObject)this._instrumentList.elementAt(i)).getPowerStatus();
            }
            ++i;
        }
        return null;
    }

    public int getInstrumentListSize() {
        return this._instrumentList.size();
    }

    public InstrumentPowerObject getInstrumentPowerObject(int i) {
        return (InstrumentPowerObject)this._instrumentList.elementAt(i);
    }

    public void setPowerStatus(String s) {
        this._powerStatus = s;
    }

    public Vector getInstruments() {
        return this._instrumentList;
    }

    public Node getNodeService() {
        String nodeUrl = "rmi://" + this._name + "/node";
        Node nodeService = null;
        this.setSecurityManager();
        try {
            System.out.println("Looking for node service at " + nodeUrl);
            nodeService = (Node)Naming.lookup(nodeUrl);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + nodeUrl + "\"");
            return null;
        }
        return nodeService;
    }

    public void setSecurityManager() {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
        }
        catch (Exception e) {
            System.err.println("Exception caught " + e);
        }
    }

    public Node getNode() {
        return this._node;
    }
}

