/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.CombinedXYPlot;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYDataset;
import com.strangeberry.rendezvous.Rendezvous;
import com.strangeberry.rendezvous.ServiceInfo;
import com.strangeberry.rendezvous.ServiceListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import moos.operations.utils.node.BaseSettings;
import moos.operations.utils.node.CellObject;
import moos.operations.utils.node.EnvDataset;
import moos.operations.utils.node.EnvDatasetThread;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.InstrumentPowerObject;
import moos.operations.utils.node.NodeControlCellRenderer;
import moos.operations.utils.node.NodePowerObject;
import moos.operations.utils.node.SettingsPanel;
import moos.operations.utils.node.TreeNodeCellEditor;
import moos.operations.utils.node.UpdateEnvDataThread;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.Node;

public class NodePowerControls
extends JFrame
implements ActionListener,
TreeSelectionListener,
ServiceListener,
WindowListener {
    private Vector _nodeList = new Vector();
    private DefaultMutableTreeNode _hierarchyRoot = new DefaultMutableTreeNode("ROOT");
    private JTree _tree = null;
    private JScrollPane _treePane = null;
    private CellObject _selectedItem = null;
    private JTextField _sensorReading = new JTextField();
    private JPanel _gfPanel = null;
    private JPanel _gfLabelPanel = new JPanel();
    private JLabel _gfLabel = new JLabel("Ground Fall");
    private Instrument _instrument = null;
    private Vector dataList = new Vector();
    private ResourceBundle resources;
    private UpdateEnvDataThread _updateThread = null;
    private EnvDatasetThread _update = null;
    private Rendezvous _rendezvous = null;
    private String[] _types = new String[]{"node.siam._rmi._tcp.local."};
    private JMenuBar _menuBar = new JMenuBar();
    private JMenu _settings = new JMenu("Settings");
    private JMenuItem _changeSettings = new JMenuItem("Change Settings");
    private JSplitPane _splitPane = null;
    private JSplitPane _graphPanel = null;
    private SettingsPanel _settingsPanel = null;
    private BaseSettings _base;

    public NodePowerControls() {
        super("Node Power Control");
        this.setDefaultCloseOperation(2);
        ((Component)this).setSize(800, 700);
        this.addWindowListener(this);
        try {
            this._rendezvous = new Rendezvous();
        }
        catch (IOException e) {
            System.out.println(" Caught exception " + e);
        }
        this._rendezvous.addServiceListener(this._types[0], this);
        this._changeSettings.addActionListener(this);
        this._settings.add(this._changeSettings);
        this._menuBar.add(this._settings);
        this.setJMenuBar(this._menuBar);
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            System.out.println("caught exception " + e + "while trying to sleep");
        }
        this.makeTree();
        this._tree = new JTree(this._hierarchyRoot);
        this._tree.addTreeSelectionListener(this);
        this._treePane = new JScrollPane(this._tree);
        this._tree.setEditable(true);
        this._tree.setCellRenderer(new NodeControlCellRenderer());
        this._tree.setCellEditor(new TreeNodeCellEditor());
        this._gfPanel = new JPanel();
        this._graphPanel = new JSplitPane(1, this._gfPanel, this._settingsPanel);
        this._graphPanel.setOneTouchExpandable(true);
        this._graphPanel.setDividerLocation(0.6);
        this._graphPanel.setLeftComponent(this._gfPanel);
        this._graphPanel.setRightComponent(this._settingsPanel);
        this._splitPane = new JSplitPane(0, this._treePane, this._graphPanel);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setDividerLocation(0.7);
        this._splitPane.setTopComponent(this._treePane);
        this._splitPane.setBottomComponent(this._graphPanel);
        this._treePane.setMinimumSize(new Dimension(500, 250));
        this._graphPanel.setMinimumSize(new Dimension(500, 50));
        this.getContentPane().add(this._splitPane);
        ((Component)this).setVisible(true);
    }

    public void makeTree() {
        System.out.println("size of nodeList" + this._nodeList.size());
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode instrument = null;
        NodePowerObject n = null;
        CellObject cellObjectForNode = null;
        CellObject cellObjectForInstrument = null;
        int i = 0;
        while (i < this._nodeList.size()) {
            cellObjectForNode = (CellObject)this._nodeList.elementAt(i);
            n = (NodePowerObject)cellObjectForNode.getDataObject();
            node = new DefaultMutableTreeNode(cellObjectForNode);
            int j = 0;
            while (j < n.getInstrumentListSize()) {
                cellObjectForInstrument = new CellObject(n.getInstrumentPowerObject(j));
                instrument = new DefaultMutableTreeNode(cellObjectForInstrument);
                node.add(instrument);
                ++j;
            }
            this._hierarchyRoot.add(node);
            ++i;
        }
    }

    public void fillData() {
        NodePowerObject n = new NodePowerObject("ON", "sidearm310");
        CellObject o = new CellObject(n);
        this._nodeList.add(o);
        NodePowerObject n2 = new NodePowerObject("ON", "sidearm6");
        CellObject o2 = new CellObject(n2);
        this._nodeList.add(o2);
    }

    public void addService(Rendezvous rendezvous, String type, String name) {
        if (name.endsWith("." + type)) {
            name = name.substring(0, name.length() - (type.length() + 1));
        }
        NodePowerObject n = new NodePowerObject("ON", name);
        CellObject cell = new CellObject(n);
        System.out.println("adding " + name + " to nodelist");
        this._nodeList.add(cell);
    }

    public void removeService(Rendezvous rendezvous, String type, String name) {
    }

    public void resolveService(Rendezvous rendezvous, String type, String name, ServiceInfo info) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode source = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        this._selectedItem = (CellObject)source.getUserObject();
        String name = null;
        if (!(this._selectedItem.getDataObject() instanceof InstrumentPowerObject)) {
            NodePowerObject o = (NodePowerObject)this._selectedItem.getDataObject();
            Node node = o.getNode();
            try {
                this._instrument = (Instrument)node.getDevice(1217L);
            }
            catch (DeviceNotFound d) {
                System.out.println("Device not found");
            }
            catch (RemoteException r) {
                System.out.println("Remote Exception");
            }
            name = o.getName();
            if (this._settingsPanel != null) {
                this._settingsPanel.saveSettings();
            }
            this._graphPanel.removeAll();
            this._gfPanel.removeAll();
            this._splitPane.remove(this._graphPanel);
            this._graphPanel.removeAll();
            this._graphPanel = null;
            System.out.println("Here");
            if (this._updateThread != null) {
                this._updateThread.setRun(false);
                this._updateThread = null;
            }
            if (this._update != null) {
                this._update.setRun(false);
                this._update = null;
            }
            System.out.println("Here");
            this.dataList = new Vector();
            if (this._instrument != null) {
                this._gfPanel = this.makeGraph(name);
                System.out.println("Make graph called");
                this._updateThread = new UpdateEnvDataThread(this._instrument, this.dataList, this);
                Thread dataThread = new Thread(this._updateThread);
                dataThread.start();
                this._update = new EnvDatasetThread(this.dataList, this, this._base);
                Thread UIthread = new Thread(this._update);
                UIthread.start();
            } else {
                JLabel l = new JLabel("COULD NOT FIND A INSTRUMENT");
                JPanel errorPanel = new JPanel();
                errorPanel.add(l);
                this._gfPanel = errorPanel;
            }
            this._settingsPanel = new SettingsPanel(this.dataList, name);
            this._graphPanel = new JSplitPane(1, this._gfPanel, this._settingsPanel);
            this._graphPanel.setOneTouchExpandable(true);
            this._graphPanel.setDividerLocation(0.6);
            this._graphPanel.setLeftComponent(this._gfPanel);
            this._graphPanel.setRightComponent(this._settingsPanel);
            this._gfPanel.setMinimumSize(new Dimension(500, 50));
            this._settingsPanel.setMinimumSize(new Dimension(200, 50));
            this._graphPanel.setMinimumSize(new Dimension(100, 50));
            this._splitPane.setBottomComponent(this._graphPanel);
            ((Component)this).setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            // empty if block
        }
    }

    public void switchAllInstrumentsOff(NodePowerObject n) {
        InstrumentPowerObject ins = null;
        Vector v = n.getInstruments();
        int i = 0;
        while (i < v.size()) {
            ins = (InstrumentPowerObject)v.elementAt(i);
            ++i;
        }
    }

    public ChartPanel makeGraph(String name) {
        String baseResourceClass = "com.jrefinery.chart.demo.resources.DemoResources";
        this.resources = ResourceBundle.getBundle(baseResourceClass);
        String title = "Ground Fault Chart for " + name;
        String subtitleStr = "GroundFault High and GroundFault low";
        String domain = this.resources.getString("combined.dynamic.domain");
        String[] ranges = this.resources.getStringArray("combined.dynamic.ranges");
        this._base = new BaseSettings(name);
        EnvDataset data1 = new EnvDataset(GUIConstants.GFHIGH, this._instrument, this._base);
        EnvDataset data2 = new EnvDataset(GUIConstants.GFLOW, this._instrument, this._base);
        this.dataList.add(data1);
        this.dataList.add(data2);
        HorizontalDateAxis timeAxis = new HorizontalDateAxis(domain);
        timeAxis.setTickMarksVisible(true);
        timeAxis.setCrosshairVisible(false);
        NumberAxis[] valueAxis = new NumberAxis[2];
        int i = 0;
        while (i < valueAxis.length) {
            valueAxis[i] = new VerticalNumberAxis(ranges[i]);
            valueAxis[i].setAutoRangeIncludesZero(false);
            valueAxis[i].setCrosshairVisible(false);
            ++i;
        }
        CombinedXYPlot plot = new CombinedXYPlot((ValueAxis)timeAxis, 1);
        XYPlot subplot0 = new XYPlot((XYDataset)data1, null, (ValueAxis)valueAxis[0]);
        plot.add(subplot0, 1);
        XYPlot subplot1 = new XYPlot((XYDataset)data2, null, (ValueAxis)valueAxis[1]);
        plot.add(subplot1, 1);
        JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 12), (Plot)plot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        return chartPanel;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this._settingsPanel != null) {
            this._settingsPanel.saveSettings();
        }
    }
}

