/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import com.strangeberry.rendezvous.Rendezvous;
import com.strangeberry.rendezvous.ServiceInfo;
import com.strangeberry.rendezvous.ServiceListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import moos.operations.utils.node.EnvChart;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.MessageBox;
import moos.operations.utils.node.NodeFrame;

public class Login
extends JFrame
implements ActionListener,
KeyListener,
ServiceListener {
    private JLabel _nodeNameLabel = new JLabel("Node Name");
    private JComboBox _nodeName = new JComboBox();
    private JLabel _passWordLabel = new JLabel("Password");
    private JTextField _passWordText = new JTextField();
    private JButton _viewButton = new JButton("View");
    private JButton _exitButton = new JButton("Close");
    private Rendezvous _rendezvous = null;
    private String[] _types = new String[]{"node.siam._rmi._tcp.local."};
    private String _openWindow;

    public Login(String window) {
        super("Login");
        this._openWindow = window;
        ((Component)this).setSize(400, 150);
        try {
            this._rendezvous = new Rendezvous();
        }
        catch (IOException e) {
            System.out.println("exception caught" + e);
            e.printStackTrace();
        }
        this._rendezvous.addServiceListener(this._types[0], this);
        this._nodeNameLabel.setBounds(10, 10, 100, 18);
        this._nodeNameLabel.setForeground(GUIConstants.BLACK);
        this._nodeName.setBounds(130, 10, 150, 18);
        this._nodeName.setFont(GUIConstants.FONT);
        this._nodeName.setEditable(true);
        this._passWordLabel.setBounds(10, 35, 150, 18);
        this._passWordLabel.setForeground(GUIConstants.BLACK);
        this._passWordText.setBounds(130, 35, 150, 18);
        this._passWordText.setFont(GUIConstants.FONT);
        this._nodeName.addKeyListener(this);
        this._viewButton.setBounds(110, 75, 80, 20);
        this._viewButton.addActionListener(this);
        this._viewButton.addKeyListener(this);
        this._exitButton.setBounds(210, 75, 80, 20);
        this._exitButton.addActionListener(this);
        this._exitButton.addKeyListener(this);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this._nodeNameLabel);
        this.getContentPane().add(this._nodeName);
        this.getContentPane().add(this._passWordLabel);
        this.getContentPane().add(this._passWordText);
        this.getContentPane().add(this._viewButton);
        this.getContentPane().add(this._exitButton);
        this.show();
    }

    public void actionPerformed(ActionEvent event) {
        String buttonName = ((JButton)event.getSource()).getText();
        if (buttonName.equals("View")) {
            if (((String)this._nodeName.getSelectedItem()).equals("")) {
                MessageBox b = new MessageBox("Enter Node Name");
            } else {
                String nodeName = (String)this._nodeName.getSelectedItem();
                if (this._openWindow.equals("NodeView")) {
                    NodeFrame frame = new NodeFrame(nodeName);
                    this.dispose();
                } else {
                    EnvChart c = new EnvChart(nodeName);
                    this.dispose();
                }
            }
        } else {
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        Object source = event.getSource();
        if (source instanceof JComboBox) {
            if (event.getKeyChar() == '\n') {
                if (((String)this._nodeName.getSelectedItem()).equals("\n")) {
                    MessageBox b = new MessageBox("Enter Node Name");
                } else {
                    String nodeName = (String)this._nodeName.getSelectedItem();
                    NodeFrame frame = new NodeFrame(nodeName);
                    this.dispose();
                }
            }
        } else {
            ((JButton)source).doClick();
        }
    }

    public void addService(Rendezvous rendezvous, String type, String name) {
        if (name.endsWith("." + type)) {
            name = name.substring(0, name.length() - (type.length() + 1));
        }
        this._nodeName.addItem(name);
    }

    public void removeService(Rendezvous rendezvous, String type, String name) {
        if (name.endsWith("." + type)) {
            name = name.substring(0, name.length() - (type.length() + 1));
        }
        this._nodeName.removeItem(name);
    }

    public void resolveService(Rendezvous rendezvous, String type, String name, ServiceInfo info) {
    }
}

