/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import com.jrefinery.chart.demo.SampleXYDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import moos.operations.utils.node.BaseSettings;
import moos.operations.utils.node.DataQueue;
import moos.operations.utils.node.GFHighSettings;
import moos.operations.utils.node.GFLowSettings;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.HumiditySettings;
import moos.operations.utils.node.PressureSettings;
import moos.operations.utils.node.TemperatureSettings;
import moos.operations.utils.nodeview.monitor.EnvironmentalPacketParser;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.SensorDataPacket;

public class EnvDataset
extends SampleXYDataset {
    String _envVariable;
    Instrument _instrument;
    DataQueue _data;
    Object _settings;
    BaseSettings _base;

    public EnvDataset(String name, Instrument ins, BaseSettings base) {
        this._envVariable = name;
        this._instrument = ins;
        this._base = base;
        HashMap set = this.getFileSettings();
        this._settings = set == null ? (name.equals(GUIConstants.TEMPERATURE) ? new TemperatureSettings(base) : (name.equals(GUIConstants.PRESSURE) ? new PressureSettings(base) : (name.equals(GUIConstants.HUMIDITY) ? new HumiditySettings(base) : (name.equals(GUIConstants.GFHIGH) ? new GFHighSettings(base) : new GFLowSettings(base))))) : (name.equals(GUIConstants.TEMPERATURE) ? (TemperatureSettings)set.get(GUIConstants.TEMPERATURE) : (name.equals(GUIConstants.PRESSURE) ? (PressureSettings)set.get(GUIConstants.PRESSURE) : (name.equals(GUIConstants.HUMIDITY) ? (HumiditySettings)set.get(GUIConstants.HUMIDITY) : (name.equals(GUIConstants.GFHIGH) ? (GFHighSettings)set.get(GUIConstants.GFHIGH) : (GFLowSettings)set.get(GUIConstants.GFLOW)))));
        EnvironmentalPacketParser parser = new EnvironmentalPacketParser();
        Long time = null;
        try {
            SensorDataPacket dataPacket = this._instrument.acquireSample(false);
            parser.parse(dataPacket);
            time = (Long)parser.get(0);
        }
        catch (NoDataException d) {
            System.out.println("No data");
        }
        catch (RemoteException e) {
            System.out.println("RemoteException");
        }
        this._data = new DataQueue(name, time, this._settings);
    }

    public void add(Double xvalue, Double yvalue) {
        this._data.add(xvalue, yvalue);
    }

    public void setTranslate(double whatever) {
        this.notifyListeners(new DatasetChangeEvent((Object)this, (Dataset)this));
    }

    public Number getXValue(int series, int n) {
        Double[] data = this._data.get(n);
        return data[0];
    }

    public Number getYValue(int series, int n) {
        Double[] data = this._data.get(n);
        return data[1];
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int series) {
        return this._envVariable;
    }

    public int getItemCount(int series) {
        return this._base.SAMPLECOUNT;
    }

    public Object getSettings() {
        return this._settings;
    }

    public HashMap getFileSettings() {
        String fileName = this._envVariable.equals(GUIConstants.TEMPERATURE) || this._envVariable.equals(GUIConstants.PRESSURE) || this._envVariable.equals(GUIConstants.HUMIDITY) ? this._base.NODENAME + "_ENV.set" : this._base.NODENAME + "_GF.set";
        try {
            FileInputStream in = new FileInputStream(fileName);
            ObjectInputStream s = new ObjectInputStream(in);
            HashMap set = (HashMap)s.readObject();
            return set;
        }
        catch (FileNotFoundException exception) {
            return null;
        }
        catch (IOException exception) {
            return null;
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }
}

