/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.CombinedXYPlot;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Window;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import moos.operations.utils.node.BaseSettings;
import moos.operations.utils.node.EnvDataset;
import moos.operations.utils.node.EnvDatasetThread;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.UpdateEnvDataThread;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.Node;

public class EnvChart {
    private ResourceBundle resources;
    private ChartFrame combinedAndOverlaidDynamicXYChartFrame;
    private Vector dataList = new Vector();
    private Instrument _instrument;
    private String _nodeName;
    private BaseSettings _base;

    public EnvChart(String nodeName) {
        this._nodeName = nodeName;
        Node node = this.getNodeService();
        try {
            this._instrument = (Instrument)node.getDevice(1217L);
        }
        catch (DeviceNotFound d) {
            System.out.println("Device not found");
        }
        catch (RemoteException e) {
            System.out.println("Remote Exception");
        }
        if (this._instrument != null) {
            System.out.println("Got instrument .. making chart");
            this.makeChart();
            UpdateEnvDataThread updateThread = new UpdateEnvDataThread(this._instrument, this.dataList, (JFrame)this.combinedAndOverlaidDynamicXYChartFrame);
            Thread dataThread = new Thread(updateThread);
            dataThread.start();
            EnvDatasetThread update = new EnvDatasetThread(this.dataList, (JFrame)this.combinedAndOverlaidDynamicXYChartFrame, this._base);
            Thread UIthread = new Thread(update);
            UIthread.start();
        } else {
            System.out.print("Did not get instrument");
        }
    }

    public void makeChart() {
        String title = "Environmental Chart for '" + this._nodeName + "'";
        String subtitleStr = "Temperature, Pressure and Humidity";
        String domain = "Time";
        String[] ranges = new String[]{"Temperature", "Pressure", "Humidity"};
        this._base = new BaseSettings(this._nodeName);
        EnvDataset data1 = new EnvDataset(GUIConstants.TEMPERATURE, this._instrument, this._base);
        EnvDataset data2 = new EnvDataset(GUIConstants.PRESSURE, this._instrument, this._base);
        EnvDataset data3 = new EnvDataset(GUIConstants.HUMIDITY, this._instrument, this._base);
        this.dataList.add(data1);
        this.dataList.add(data2);
        this.dataList.add(data3);
        HorizontalDateAxis timeAxis = new HorizontalDateAxis(domain);
        timeAxis.setTickMarksVisible(true);
        timeAxis.setCrosshairVisible(false);
        NumberAxis[] valueAxis = new NumberAxis[3];
        int i = 0;
        while (i < valueAxis.length) {
            valueAxis[i] = new VerticalNumberAxis(ranges[i]);
            valueAxis[i].setAutoRangeIncludesZero(false);
            valueAxis[i].setCrosshairVisible(false);
            ++i;
        }
        CombinedXYPlot plot = new CombinedXYPlot((ValueAxis)timeAxis, 1);
        XYPlot subplot0 = new XYPlot((XYDataset)data1, null, (ValueAxis)valueAxis[0]);
        plot.add(subplot0, 1);
        XYPlot subplot1 = new XYPlot((XYDataset)data2, null, (ValueAxis)valueAxis[1]);
        plot.add(subplot1, 1);
        XYPlot subplot2 = new XYPlot((XYDataset)data3, null, (ValueAxis)valueAxis[2]);
        plot.add(subplot2, 1);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.combinedAndOverlaidDynamicXYChartFrame = new ChartFrame(this._nodeName, title, chart);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle((AbstractTitle)subtitle);
        chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.cyan));
        this.combinedAndOverlaidDynamicXYChartFrame.pack();
        RefineryUtilities.positionFrameRandomly((Window)this.combinedAndOverlaidDynamicXYChartFrame);
        this.combinedAndOverlaidDynamicXYChartFrame.setVisible(true);
        this.combinedAndOverlaidDynamicXYChartFrame.show();
    }

    public Node getNodeService() {
        Node nodeService = null;
        String nodeUrl = "rmi://" + this._nodeName + "/node";
        this.setSecurityManager();
        try {
            System.out.println("Looking for node service at " + nodeUrl);
            nodeService = (Node)Naming.lookup(nodeUrl);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + nodeUrl + "\"");
            return null;
        }
        return nodeService;
    }

    public void setSecurityManager() {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
        }
        catch (Exception e) {
            System.err.println("Exception caught " + e);
        }
    }
}

