/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.util.Vector;
import moos.operations.utils.node.BaseSettings;
import moos.operations.utils.node.GFHighSettings;
import moos.operations.utils.node.GFLowSettings;
import moos.operations.utils.node.GUIConstants;
import moos.operations.utils.node.HumiditySettings;
import moos.operations.utils.node.PressureSettings;
import moos.operations.utils.node.TemperatureSettings;

public class DataQueue {
    private Vector _dataList;
    String _name;

    public DataQueue(String name, long startTime, Object settings) {
        this._name = name;
        BaseSettings base = null;
        if (name.equals(GUIConstants.TEMPERATURE)) {
            base = ((TemperatureSettings)settings).baseSettings;
        }
        if (name.equals(GUIConstants.PRESSURE)) {
            base = ((PressureSettings)settings).baseSettings;
        }
        if (name.equals(GUIConstants.HUMIDITY)) {
            base = ((HumiditySettings)settings).baseSettings;
        }
        if (name.equals(GUIConstants.GFHIGH)) {
            base = ((GFHighSettings)settings).baseSettings;
        }
        if (name.equals(GUIConstants.GFLOW)) {
            base = ((GFLowSettings)settings).baseSettings;
        }
        this._dataList = new Vector(base.SAMPLECOUNT);
        int j = base.SAMPLECOUNT;
        int refreshTime = base.SAMPLETIME;
        int i = 0;
        while (i < base.SAMPLECOUNT) {
            Double[] data = new Double[]{new Double(startTime - (long)(j * refreshTime * 1000)), new Double(-1000.0)};
            this._dataList.add(data);
            ++i;
            --j;
        }
    }

    public void add(Double xData, Double yData) {
        this._dataList.remove(0);
        Double[] data = new Double[]{xData, yData};
        this._dataList.add(data);
    }

    public Double[] get(int n) {
        return (Double[])this._dataList.elementAt(n);
    }

    public void printData() {
        int i = 0;
        while (i < this._dataList.size()) {
            Double[] d = (Double[])this._dataList.elementAt(i);
            System.out.println("i=" + i + "d[0]=" + d[0] + " d[1]=" + d[1]);
            ++i;
        }
    }
}

