/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Keymap;
import moos.operations.utils.node.ConsoleSettings;
import moos.operations.utils.node.DontTypeAction;
import moos.operations.utils.node.MessageBox;
import moos.operations.utils.node.Operations;
import moos.operations.utils.node.PortProxy;
import moos.operations.utils.node.SerialPortReadThread;
import moos.operations.utils.node.TimeoutInterface;
import moos.operations.utils.node.TimeoutThread;
import org.mbari.isi.interfaces.RemoteSerialPort;

public class Console
extends JFrame
implements KeyListener,
WindowListener,
TimeoutInterface,
ActionListener,
CaretListener {
    private JPanel _consolePanel = new JPanel();
    private JTextArea _console = new JTextArea();
    private JSplitPane _statusPanel;
    private JTextField _statusField = new JTextField("----Errors will be displayed here----");
    private JTextField _timeOutTextField = new JTextField();
    private JSplitPane _splitPane;
    private int _charNos = 0;
    private Insets _inset = new Insets(0, 10, 0, 0);
    private PortProxy _port;
    private Operations _parentWindow;
    private RemoteSerialPort _remoteSerialPort;
    SerialPortReadThread _serialRead;
    TimeoutThread _timeout;
    private int _separatorPosition = 0;
    private String _letter = null;
    private JMenuItem _menu = new JMenuItem("Settings");
    private boolean _echo = false;
    public boolean _addNewLineRead = false;
    private boolean _addNewLineWrite = false;
    private boolean _sendCarraigeReturn = false;
    private boolean _sendNewLine = false;

    public Console(PortProxy port, Operations op, RemoteSerialPort serialPort) {
        super("Console");
        this._port = port;
        this._parentWindow = op;
        this._remoteSerialPort = serialPort;
        ((Component)this).setSize(700, 520);
        this.setDefaultCloseOperation(2);
        this._console.setBackground(Color.black);
        this._console.setForeground(Color.white);
        this._console.setFont(new Font("SanSerif", 1, 18));
        this._console.setCaretColor(Color.white);
        this._console.addKeyListener(this);
        this._console.setLineWrap(true);
        this._statusField.setForeground(Color.red);
        this._statusField.setFont(new Font("SanSerif", 1, 12));
        JScrollPane areaScrollPane = new JScrollPane(this._console);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(690, 590));
        this._statusPanel = new JSplitPane(1, this._statusField, this._timeOutTextField);
        this._statusPanel.setDividerLocation(500);
        this._statusPanel.setDividerSize(0);
        this._statusPanel.setLeftComponent(this._statusField);
        this._statusPanel.setRightComponent(this._timeOutTextField);
        this._splitPane = new JSplitPane(0, areaScrollPane, this._statusPanel);
        this._splitPane.setDividerLocation(440);
        this._splitPane.setDividerSize(0);
        this._splitPane.setTopComponent(areaScrollPane);
        this._splitPane.setBottomComponent(this._statusPanel);
        this.getContentPane().add(this._splitPane);
        this.addWindowListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu edit = new JMenu("Edit");
        menuBar.add(edit);
        edit.add(this._menu);
        this._menu.addActionListener(this);
        this.setJMenuBar(menuBar);
        this._console.addCaretListener(this);
        this._serialRead = new SerialPortReadThread(this._remoteSerialPort, this);
        Thread readThread = new Thread(this._serialRead);
        readThread.start();
        String siamHome = System.getProperty("siam_home");
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(siamHome + "/properties/UIProperties.properties"));
        }
        catch (IOException e) {
            System.out.println("Caught Exception" + e);
        }
        String value = prop.getProperty("consoleTimeOut");
        int t = Integer.parseInt(value);
        this._timeout = new TimeoutThread(this, t * 1000);
        Thread timeoutThread = new Thread(this._timeout);
        timeoutThread.start();
        this._console.requestFocus();
        this._console.moveCaretPosition(this.getSeparatorPosition());
        ((Component)this).setVisible(true);
    }

    public void keyTyped(KeyEvent event) {
        this._timeout.reset();
        try {
            if (this._sendCarraigeReturn) {
                this._remoteSerialPort.write('\r');
            } else if (this._sendNewLine) {
                this._remoteSerialPort.write('\n');
            } else {
                this._remoteSerialPort.write(event.getKeyChar());
            }
            System.out.println("writing :" + event.getKeyChar());
            if (this._addNewLineWrite && this._sendCarraigeReturn) {
                System.out.println("sending a \n with \r");
                this._remoteSerialPort.write('\n');
            }
        }
        catch (IOException e) {
            this.setError("IOException caught");
        }
    }

    public void keyPressed(KeyEvent event) {
        if (event.isControlDown() && event.getKeyCode() == 77 || event.getKeyCode() == 10) {
            System.out.println("Control M pressed! ");
            this._sendCarraigeReturn = true;
        }
        if (event.isControlDown() && event.getKeyCode() == 74) {
            System.out.println("Control J pressed! ");
            this._sendNewLine = true;
        }
        if (!this._echo) {
            this.setKeyAction(event);
        }
    }

    public void keyReleased(KeyEvent event) {
        if (!this._echo) {
            this.removeKeyAction(event);
        }
        this.keyReleasedFunction(event);
        if (this._sendCarraigeReturn) {
            this._sendCarraigeReturn = false;
        }
        if (this._sendNewLine) {
            this._sendNewLine = false;
        }
    }

    public void keyReleasedFunction(KeyEvent event) {
        try {
            if (this._addNewLineWrite && this._sendNewLine) {
                System.out.println("sending a \r with \n");
                this._remoteSerialPort.write('\r');
            }
        }
        catch (Exception e) {
            System.out.println("caught exception " + e);
        }
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.cleanUp(false);
    }

    public void caretUpdate(CaretEvent event) {
        int p = event.getDot();
        if (p < this.getSeparatorPosition()) {
            this._console.setEditable(false);
            this._console.setCaretPosition(this.getSeparatorPosition());
        } else {
            this._console.setEditable(true);
        }
    }

    public void cleanUp(boolean sessionDisconnected) {
        String error = this._port.resumeService();
        if (error != null) {
            this._parentWindow.setErrorMessage(error);
        }
        this._serialRead.setRun(false);
        this._timeout.setRun(false);
        if (sessionDisconnected) {
            MessageBox messageBox = new MessageBox("Your session has timed out");
        }
    }

    public void setError(String e) {
        this._statusField.setText(e);
    }

    public void appendToConsole(char c) {
        this._console.append(String.valueOf(c));
    }

    public String getText() {
        return this._console.getText();
    }

    public void setCursorPosition(int p) {
        try {
            this._console.setCaretPosition(p);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setSeparatorPosition(p - 1);
            this._console.setCaretPosition(p - 1);
        }
    }

    public void update(long time) {
        this._timeOutTextField.setText("Console will close in : " + new Long(time / 1000L) + "s");
    }

    public void quit() {
        this.cleanUp(true);
        this.dispose();
    }

    public void modifySettings(boolean echoValue, boolean addNewLineReadValue, boolean addNewLineWriteValue) {
        this._echo = echoValue;
        this._addNewLineRead = addNewLineReadValue;
        this._addNewLineWrite = addNewLineWriteValue;
    }

    public void setSeparatorPosition(int position) {
        this._separatorPosition = position;
    }

    public void actionPerformed(ActionEvent event) {
        ConsoleSettings consoleSettings = new ConsoleSettings(this, this._echo, this._addNewLineRead, this._addNewLineWrite);
    }

    public int getSeparatorPosition() {
        return this._separatorPosition;
    }

    public void setKeyAction(KeyEvent event) {
        char c = event.getKeyChar();
        Keymap keymap = this._console.getKeymap();
        if (keymap != null) {
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(c), (Action)DontTypeAction.ACTION_DontTypeAnything);
        }
    }

    public void removeKeyAction(KeyEvent event) {
        char c = event.getKeyChar();
        Keymap keymap = this._console.getKeymap();
        if (keymap != null) {
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(c));
        }
    }
}

