/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils.node;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import moos.operations.utils.node.InstrumentPowerObject;
import moos.operations.utils.node.NodePowerObject;
import moos.operations.utils.nodeview.monitor.EnvironmentalPacketParser;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.SensorDataPacket;

public class CellObject
extends JPanel
implements ActionListener {
    JLabel _name = new JLabel();
    JLabel _tempReading = new JLabel();
    JLabel _humidityReading = new JLabel();
    JLabel _pressureReading = new JLabel();
    JToggleButton _devicePower = new JToggleButton("Device");
    JToggleButton _commsPower = new JToggleButton("Comms");
    Object _dataObject = null;
    JLabel _topSpacePanel = new JLabel("       ");
    JLabel _bottomSpacePanel = new JLabel("         ");
    JPanel _middlePanel = new JPanel();
    private EnvironmentalPacketParser _parser = new EnvironmentalPacketParser();

    public CellObject(Object dataObject) {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBag = new GridBagLayout();
        this._middlePanel.setLayout(gridBag);
        GridBagConstraints constraints = new GridBagConstraints();
        this._middlePanel.setBackground(Color.lightGray);
        this._dataObject = dataObject;
        constraints.gridwidth = 2;
        constraints.gridx = 1;
        constraints.gridy = 0;
        gridBag.setConstraints(this._name, constraints);
        this._middlePanel.add(this._name);
        this._name.setForeground(Color.blue.darker().darker());
        if (this._dataObject instanceof NodePowerObject) {
            NodePowerObject n = (NodePowerObject)this._dataObject;
            this._name.setText("Node : " + n.getName());
            Double temp = null;
            Double humidity = null;
            Double pressure = null;
            Node node = n.getNode();
            try {
                Instrument ins = (Instrument)node.getDevice(1217L);
                SensorDataPacket dataPacket = ins.acquireSample(false);
                this._parser.parse(dataPacket);
                temp = (Double)this._parser.get(5);
                humidity = (Double)this._parser.get(7);
                pressure = (Double)this._parser.get(6);
            }
            catch (DeviceNotFound d) {
                System.out.println("Device not found");
            }
            catch (RemoteException e) {
                System.out.println("Remote Exception");
            }
            catch (NoDataException e) {
                System.out.println("No data");
            }
            if (temp != null) {
                this._tempReading.setText("Temperature : " + temp.toString());
                this._humidityReading.setText("Humidity : " + humidity.toString());
                this._pressureReading.setText("Pressure : " + pressure.toString());
            } else {
                this._tempReading.setText("Temperature : ");
                this._humidityReading.setText("Humidity : ");
                this._pressureReading.setText("Pressure : ");
            }
        } else if (this._dataObject instanceof InstrumentPowerObject) {
            this._name.setText("Instrument : " + ((InstrumentPowerObject)this._dataObject).getName());
            constraints.gridx = 0;
            constraints.gridy = 1;
            gridBag.setConstraints(this._devicePower, constraints);
            this._middlePanel.add(this._devicePower);
            constraints.gridx = 2;
            constraints.gridy = 1;
            gridBag.setConstraints(this._commsPower, constraints);
            this._middlePanel.add(this._commsPower);
        }
        this._devicePower.setActionCommand("Device");
        this._commsPower.setActionCommand("Comms");
        this._tempReading.setForeground(Color.black);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 2;
        gridBag.setConstraints(this._tempReading, constraints);
        this._middlePanel.add(this._tempReading);
        this._humidityReading.setForeground(Color.black);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 3;
        gridBag.setConstraints(this._humidityReading, constraints);
        this._middlePanel.add(this._humidityReading);
        this._pressureReading.setForeground(Color.black);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 4;
        gridBag.setConstraints(this._pressureReading, constraints);
        this._middlePanel.add(this._pressureReading);
        this._devicePower.addActionListener(this);
        this._commsPower.addActionListener(this);
        this.setBackground(Color.white);
        this._topSpacePanel.setSize(200, 10);
        this._topSpacePanel.setBackground(Color.white);
        this._bottomSpacePanel.setSize(200, 10);
        this._bottomSpacePanel.setBackground(Color.white);
        this.add((Component)this._topSpacePanel, "North");
        this.add((Component)this._middlePanel, "Center");
        this.add((Component)this._bottomSpacePanel, "South");
    }

    public void setDevicePower(boolean v) {
        this._devicePower.setSelected(v);
    }

    public void setCommsPower(boolean v) {
        this._commsPower.setSelected(v);
    }

    public Object getDataObject() {
        return this._dataObject;
    }

    public void actionPerformed(ActionEvent event) {
        JToggleButton source = (JToggleButton)event.getSource();
        if (!source.isSelected()) {
            source.setForeground(Color.gray);
        } else {
            source.setForeground(Color.green.darker().darker().darker());
        }
    }
}

