/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipFile;
import moos.deployed.PuckHeader;
import moos.deployed.PuckOutputStream;
import moos.deployed.ServiceProperties;
import moos.utils.StopWatch;
import org.doomdark.uuid.EthernetAddress;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDGenerator;

public class WritePuck {
    private static final int _PUCK_DEFAULT_BAUD = 9600;
    private static final int _PUCK_UPLOAD_BAUD = 38400;
    private static final String _BOGUS_ETH0_ADDRESS = "00:00:00:00:00:00";
    private CommPortIdentifier _commPortId = null;
    private SerialPort _serialPort = null;
    private InputStream _serialPuckIn = null;
    private OutputStream _serialPuckOut = null;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java WritePuck [jar_file] [comm_port]");
            return;
        }
        WritePuck app = new WritePuck();
        app.execute(args[0], args[1]);
    }

    protected UUID getUUID() {
        String eth0Address = null;
        UUID uuid = null;
        Properties sysProperties = System.getProperties();
        String binLoc = sysProperties.getProperty("siam.bin");
        if (binLoc == null) {
            System.out.println("siam.bin property not set");
            System.exit(0);
        }
        binLoc = binLoc.trim();
        try {
            Process proc = Runtime.getRuntime().exec(binLoc + File.separator + "ethaddr");
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            eth0Address = br.readLine();
        }
        catch (IOException e) {
            eth0Address = _BOGUS_ETH0_ADDRESS;
        }
        UUIDGenerator uuidGen = UUIDGenerator.getInstance();
        System.out.println("Generating unique ID");
        if (eth0Address.startsWith(_BOGUS_ETH0_ADDRESS)) {
            System.err.println("!!!!!!!!!!!!!!!! WARNING !!!!!!!!!!!!!!!!");
            System.err.println("Unable to determine the ethernet address");
            System.err.println("of this machine, using randomly generated");
            System.err.println("ethernet address");
            System.err.println("!!!!!!!!!!!!!!!! WARNING !!!!!!!!!!!!!!!!");
            uuid = uuidGen.generateTimeBasedUUID();
        } else {
            uuid = uuidGen.generateTimeBasedUUID(new EthernetAddress(eth0Address));
        }
        System.out.println("Unique ID is " + uuid);
        return uuid;
    }

    protected long fileCheckSum(String fileName) throws IOException {
        CheckedInputStream cis = new CheckedInputStream(new FileInputStream(fileName), new CRC32());
        byte[] tempBuf = new byte[128];
        while (cis.read(tempBuf) >= 0) {
        }
        return cis.getChecksum().getValue();
    }

    protected PuckHeader createHeader(String fileName) throws IOException {
        PuckHeader puckHeader = new PuckHeader();
        puckHeader.setUUID(this.getUUID());
        File file = new File(fileName);
        int fileSize = (int)file.length();
        puckHeader.setPayloadSize((int)file.length());
        long cs = this.fileCheckSum(fileName);
        puckHeader.setChecksum(cs);
        System.out.println("The payload checksum is 0x" + Long.toHexString(cs));
        ServiceProperties sp = new ServiceProperties();
        ZipFile zf = new ZipFile(fileName);
        InputStream is = zf.getInputStream(zf.getEntry("service.properties"));
        sp.load(is);
        is.close();
        puckHeader.setServiceProperties(sp);
        return puckHeader;
    }

    /*
     * Loose catch block
     */
    public void execute(String fileName, String comPortName) {
        block28: {
            if (!this.initSerialPort(comPortName, 9600)) {
                System.out.println("failed to initialize " + comPortName);
                return;
            }
            PuckHeader puckHeader = null;
            try {
                puckHeader = this.createHeader(fileName);
            }
            catch (IOException e) {
                System.err.println("Failed to create the puck header");
                System.err.println(e);
                e.printStackTrace();
                return;
            }
            try {
                this._serialPuckIn = this._serialPort.getInputStream();
                this._serialPuckOut = this._serialPort.getOutputStream();
                this._serialPuckIn.skip(this._serialPuckIn.available());
                this._serialPuckOut.flush();
            }
            catch (IOException e) {
                System.out.println("Failed to acquire Serial Streams.");
                System.err.println(e);
                e.printStackTrace();
                return;
            }
            System.out.println("changing puck baudrate to 38400");
            try {
                this.setPuckBaudRate(38400);
            }
            catch (IOException e) {
                System.out.println("Failed to change puck baudrate: " + e);
                System.err.println(e);
                e.printStackTrace();
                return;
            }
            System.out.println("Opening PuckOutputStream at 38400 baud");
            PuckOutputStream puckOut = new PuckOutputStream(this._serialPuckIn, this._serialPuckOut);
            byte[] puckHeaderBytes = puckHeader.getBytes();
            System.out.println("Writing puck header");
            try {
                int i = 0;
                while (i < puckHeaderBytes.length) {
                    puckOut.write(puckHeaderBytes[i]);
                    ++i;
                }
            }
            catch (IOException e) {
                System.out.println("failed to write header to puck");
                System.err.println(e);
                e.printStackTrace();
                return;
            }
            System.out.println("Writing payload to puck");
            FileInputStream fis = null;
            int byteCount = 0;
            fis = new FileInputStream(fileName);
            while (fis.available() > 0) {
                puckOut.write(fis.read());
                if (++byteCount % 64 != 0) continue;
                System.out.write(46);
                System.out.flush();
            }
            System.out.println("");
            System.out.println("File write done, closing puck");
            Object var10_13 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (puckOut != null) {
                    puckOut.close();
                }
                if (this._serialPort != null) {
                    this._serialPort.close();
                }
                break block28;
            }
            catch (Exception e2) {}
            break block28;
            {
                catch (IOException e) {
                    System.out.println("failed to write file " + fileName + " to puck");
                    System.err.println(e);
                    e.printStackTrace();
                    Object var10_14 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (puckOut != null) {
                            puckOut.close();
                        }
                        if (this._serialPort != null) {
                            this._serialPort.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (puckOut != null) {
                        puckOut.close();
                    }
                    if (this._serialPort != null) {
                        this._serialPort.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void setPuckBaudRate(int baud) throws IOException {
        String baudString = "SB " + baud + "\r";
        this._serialPuckOut.write("\r".getBytes());
        this._serialPuckOut.write(baudString.getBytes());
        StopWatch.delay(250);
        try {
            this._serialPort.setSerialPortParams(baud, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setPuckBaud() UnsupportedCommOperationException: " + (Object)((Object)e));
        }
        this._serialPuckOut.write("\r".getBytes());
        StopWatch.delay(250);
    }

    private boolean initSerialPort(String comPortName, int baud_rate) {
        try {
            this._commPortId = CommPortIdentifier.getPortIdentifier((String)comPortName);
        }
        catch (NoSuchPortException e) {
            System.out.println("No such port " + comPortName + " " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort = (SerialPort)this._commPortId.open(this.getClass().getName(), 1000);
        }
        catch (PortInUseException e) {
            System.out.println("Port " + comPortName + " is in use " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort.setSerialPortParams(baud_rate, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

