/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Node;

public class Sync {
    public static void printUsage() {
        System.err.println("\n usage: sync nodeURL scheduleIndex <delay ms (0)>");
    }

    public static void main(String[] args) {
        Node node = null;
        Object devices = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 2) {
            Sync.printUsage();
            System.exit(1);
        }
        String nodeURL = args[0];
        int index = 0;
        long delayMillis = 0L;
        try {
            index = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            Sync.printUsage();
            System.exit(1);
        }
        if (args.length > 2) {
            if (args[2].toLowerCase().indexOf("h") >= 0) {
                Sync.printUsage();
                System.exit(1);
            }
            try {
                delayMillis = Long.parseLong(args[2]);
            }
            catch (NumberFormatException e) {
                Sync.printUsage();
                System.exit(1);
            }
        }
        try {
            System.out.println("Looking for node server stub at " + nodeURL);
            node = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(node.getName()) + "\"");
            System.out.println("Synchronizing instrument service...");
            byte[] retval = node.syncScheduleEntry(index, delayMillis);
            System.out.println("Synchronization complete; returned\n" + new String(retval));
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

