/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.OutputStream;
import moos.utils.StopWatch;

public class SwitchPuck {
    private OutputStream _serialPuckOut;
    private final int _PUCK_DEFAULT_BAUD = 9600;
    private CommPortIdentifier _commPortId;
    private SerialPort _serialPort;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: java SwitchPuck [comm_port]");
            System.exit(1);
        }
        SwitchPuck app = new SwitchPuck();
        app.execute(args[0]);
    }

    public void execute(String port_name) {
        System.out.println("Opening " + port_name + " at " + 9600 + " baud");
        if (!this.initSerialPort(port_name, 9600)) {
            System.out.println("Failed to initialize " + port_name);
            return;
        }
        try {
            this._serialPuckOut = this._serialPort.getOutputStream();
        }
        catch (IOException e) {
            System.out.println("Failed to acquire Serial out stream.");
            return;
        }
        try {
            this._serialPuckOut.write(13);
            StopWatch.delay(10);
            this._serialPuckOut.write("SM\r".getBytes());
            this._serialPort.close();
        }
        catch (IOException e) {
            System.out.println("puck error: " + e.getMessage());
            return;
        }
        System.out.println("Puck attached to " + port_name + " is in SENSOR MODE");
    }

    private boolean initSerialPort(String port_name, int baud_rate) {
        try {
            this._commPortId = CommPortIdentifier.getPortIdentifier((String)port_name);
        }
        catch (NoSuchPortException e) {
            System.out.println("No such port " + port_name + " " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort = (SerialPort)this._commPortId.open(this.getClass().getName(), 1000);
        }
        catch (PortInUseException e) {
            System.out.println("Port " + port_name + " is in use " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort.setSerialPortParams(baud_rate, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

