/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.Node;

public class StartServices {
    public static void main(String[] args) {
        Node node = null;
        Device[] devices = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length != 1) {
            System.err.println("usage: StartServices nodeURL");
            System.exit(1);
        }
        String nodeURL = args[0];
        try {
            System.out.println("Looking for node server stub at " + nodeURL);
            node = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(node.getName()) + "\"");
            devices = node.getDevices();
            System.out.println("Node has " + devices.length + " devices");
            int i = 0;
            while (i < devices.length) {
                System.out.println("\nDevice " + new String(devices[i].getName()) + ", port " + new String(devices[i].getCommPortName()));
                ++i;
            }
            node.scanPorts();
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

