/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Node;

public class ShutdownService {
    public static void main(String[] args) {
        Node node = null;
        Device[] devices = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 2) {
            System.err.println("usage: ShutdownService nodeURL commPortName");
            System.exit(1);
        }
        String nodeURL = args[0];
        try {
            System.out.println("Looking for node server stub at " + nodeURL);
            node = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(node.getName()) + "\"");
            devices = node.getDevices();
            int i = 0;
            while (i < args.length - 1) {
                try {
                    node.shutdownDeviceService(args[i + 1].getBytes());
                }
                catch (DeviceNotFound e) {
                    System.err.println("Port " + args[i + 1] + " not found");
                    System.exit(1);
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

