/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Node;

public class ShowSchedule {
    public void header() {
        System.out.println(" ");
    }

    public static void main(String[] args) {
        ShowSchedule showSchedule = new ShowSchedule();
        Node nodeService = null;
        byte[] schedule = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 1) {
            System.err.println("Usage: nodeURL <lookAheadSeconds>");
            System.exit(1);
        }
        String nodeURL = args[0];
        long lookAheadSeconds = 30L;
        try {
            if (args.length > 1) {
                lookAheadSeconds = Long.parseLong(args[1]);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("ShowSchedule: Warning! invalid lookAhead value; using defaults");
            lookAheadSeconds = 30L;
        }
        try {
            System.out.println("Looking for node service at " + nodeURL);
            nodeService = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + nodeURL + "\"");
            System.exit(1);
        }
        try {
            schedule = nodeService.getSchedule(lookAheadSeconds);
            showSchedule.header();
            System.out.println("\n" + new String(schedule));
            System.out.println("");
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Got some exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

