/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moos.deployed.PuckHeader;
import moos.deployed.PuckInputStream;
import moos.utils.StopWatch;

public class ScanPuck {
    private final int _PUCK_DEFAULT_BAUD = 9600;
    private final int _PUCK_DOWNLOAD_BAUD = 38400;
    private CommPortIdentifier _commPortId = null;
    private SerialPort _serialPort = null;
    private InputStream _serialPuckIn = null;
    private OutputStream _serialPuckOut = null;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: java ReadPuck [comm_port]");
            System.exit(1);
        }
        ScanPuck app = new ScanPuck();
        try {
            app.execute(args[0]);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void execute(String portName) throws Exception {
        if (!this.initSerialPort(portName, 9600)) {
            System.out.println("Failed to initialize " + portName);
            return;
        }
        try {
            this._serialPuckIn = this._serialPort.getInputStream();
            this._serialPuckOut = this._serialPort.getOutputStream();
            this._serialPuckIn.skip(this._serialPuckIn.available());
            this._serialPuckOut.flush();
        }
        catch (IOException e) {
            System.out.println("Failed to acquire Serial Streams.");
            return;
        }
        System.out.println("changing puck baudrate to 38400");
        try {
            this.setPuckBaudRate(38400);
        }
        catch (IOException e) {
            System.out.println("Failed to change puck baudrate: " + e);
            return;
        }
        PuckInputStream puckIn = new PuckInputStream(this._serialPuckIn, this._serialPuckOut);
        System.out.println("Opening PuckInputStream at 38400 baud");
        byte[] puckHeaderBytes = new byte[304];
        int i = 0;
        while (i < 304) {
            puckHeaderBytes[i] = (byte)puckIn.read();
            ++i;
        }
        PuckHeader puckHeader = new PuckHeader(puckHeaderBytes);
        System.out.println("org ID        : " + puckHeader.getOrgId());
        System.out.println("type ID       : " + puckHeader.getTypeId());
        System.out.println("unique ID     : " + puckHeader.getUUID());
        System.out.println("payload size  : " + puckHeader.getPayloadSize());
        System.out.println("checksum      : 0x" + Long.toHexString(puckHeader.getChecksum()));
        System.out.println("service name  : " + puckHeader.getServiceName());
        System.out.println("ISI ID        : " + puckHeader.getIsiId());
        System.out.println("current limit : " + puckHeader.getCurrentLimit());
    }

    private void setPuckBaudRate(int baud) throws IOException {
        String baudString = "SB " + baud + "\r";
        this._serialPuckOut.write("\r".getBytes());
        this._serialPuckOut.write(baudString.getBytes());
        StopWatch.delay(250);
        try {
            this._serialPort.setSerialPortParams(baud, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setPuckBaud() UnsupportedCommOperationException: " + (Object)((Object)e));
        }
        this._serialPuckOut.write("\r".getBytes());
        StopWatch.delay(250);
    }

    private boolean initSerialPort(String portName, int baud_rate) {
        try {
            this._commPortId = CommPortIdentifier.getPortIdentifier((String)portName);
        }
        catch (NoSuchPortException e) {
            System.out.println("No such port " + portName + " " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort = (SerialPort)this._commPortId.open(this.getClass().getName(), 1000);
        }
        catch (PortInUseException e) {
            System.out.println("Port " + portName + " is in use " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort.setSerialPortParams(baud_rate, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

