/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import moos.utils.PrintUtils;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.NoDataException;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.PortNotFound;
import org.mbari.isi.interfaces.SensorDataPacket;

public class SampleInstrument {
    public static void main(String[] args) {
        Node node = null;
        Device[] devices = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 2) {
            System.err.println("usage: SampleInstrument nodeURL commPortName");
            System.exit(1);
        }
        String nodeURL = args[0];
        try {
            System.out.println("Looking for node server stub at " + nodeURL);
            node = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(node.getName()) + "\"");
            devices = node.getDevices();
            int i = 0;
            while (i < args.length - 1) {
                try {
                    Device device = node.getDevice(args[i + 1].getBytes());
                    if (device instanceof Instrument) {
                        Instrument instrument = (Instrument)device;
                        SensorDataPacket packet = instrument.acquireSample(false);
                        System.out.println(packet.toString());
                        System.out.println(PrintUtils.printAscii(packet.dataBuffer(), 0, 0));
                    } else {
                        System.err.println("Device on port " + args[i + 1] + " is not an Instrument");
                    }
                }
                catch (PortNotFound e) {
                    System.err.println("Port " + args[i + 1] + " not found");
                }
                catch (DeviceNotFound e) {
                    System.err.println("Device not found on port " + args[i + 1]);
                }
                catch (NoDataException e) {
                    System.err.println("No data from instrument on port " + args[i + 1]);
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

