/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moos.deployed.PuckHeader;
import moos.deployed.PuckInputStream;
import moos.utils.StopWatch;

public class ReadPuck {
    private final int _PUCK_DEFAULT_BAUD = 9600;
    private final int _PUCK_DOWNLOAD_BAUD = 38400;
    private final int _FILE_OUTPUT_BUFF_SIZE = 1024;
    private CommPortIdentifier _commPortId = null;
    private SerialPort _serialPort = null;
    private InputStream _serialPuckIn = null;
    private OutputStream _serialPuckOut = null;
    private PuckInputStream _puckIn = null;
    private FileOutputStream _outputFile = null;
    private byte[] _fileOutputBuffer = new byte[1024];

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: java ReadPuck [comm_port]");
            System.exit(1);
        }
        ReadPuck app = new ReadPuck();
        app.execute(args[0]);
    }

    public void execute(String port_name) {
        int fileSize = 0;
        int bufferCount = 0;
        if (!this.initSerialPort(port_name, 9600)) {
            System.out.println("Failed to initialize " + port_name);
            return;
        }
        try {
            this._serialPuckIn = this._serialPort.getInputStream();
            this._serialPuckOut = this._serialPort.getOutputStream();
            this._serialPuckIn.skip(this._serialPuckIn.available());
            this._serialPuckOut.flush();
        }
        catch (IOException e) {
            System.out.println("Failed to acquire Serial Streams.");
            return;
        }
        System.out.println("changing puck baudrate to 38400");
        try {
            this.setPuckBaudRate(38400);
        }
        catch (IOException e) {
            System.out.println("Failed to change puck baudrate: " + e);
            return;
        }
        this._puckIn = new PuckInputStream(this._serialPuckIn, this._serialPuckOut);
        System.out.println("Opening PuckInputStream at 38400 baud");
        try {
            this._outputFile = new FileOutputStream("puck.jar");
        }
        catch (FileNotFoundException e) {
            System.out.println("failed to create file puck.jar");
            e.printStackTrace();
            return;
        }
        try {
            byte[] b = new byte[304];
            int i = 0;
            while (i < 304) {
                b[i] = (byte)this._puckIn.read();
                ++i;
            }
            PuckHeader puckHeader = new PuckHeader(b);
            fileSize = puckHeader.getPayloadSize();
            System.out.println("Found a " + puckHeader.getServiceName() + " service");
            System.out.println("The puck contains a payload of " + fileSize + " bytes");
            int i2 = 0;
            while (i2 < fileSize) {
                this._fileOutputBuffer[bufferCount++] = (byte)this._puckIn.read();
                if (bufferCount == 1024) {
                    this._outputFile.write(this._fileOutputBuffer);
                    bufferCount = 0;
                    System.out.write(46);
                    System.out.flush();
                }
                ++i2;
            }
            if (bufferCount > 0) {
                this._outputFile.write(this._fileOutputBuffer, 0, bufferCount);
            }
            this._outputFile.close();
            this._serialPort.close();
        }
        catch (IOException e) {
            System.out.println("failed to retrieve jar file from puck");
            e.printStackTrace();
            return;
        }
    }

    private void setPuckBaudRate(int baud) throws IOException {
        String baudString = "SB " + baud + "\r";
        this._serialPuckOut.write("\r".getBytes());
        this._serialPuckOut.write(baudString.getBytes());
        StopWatch.delay(250);
        try {
            this._serialPort.setSerialPortParams(baud, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setPuckBaud() UnsupportedCommOperationException: " + (Object)((Object)e));
        }
        this._serialPuckOut.write("\r".getBytes());
        StopWatch.delay(250);
    }

    private boolean initSerialPort(String port_name, int baud_rate) {
        try {
            this._commPortId = CommPortIdentifier.getPortIdentifier((String)port_name);
        }
        catch (NoSuchPortException e) {
            System.out.println("No such port " + port_name + " " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort = (SerialPort)this._commPortId.open(this.getClass().getName(), 1000);
        }
        catch (PortInUseException e) {
            System.out.println("Port " + port_name + " is in use " + (Object)((Object)e));
            e.printStackTrace();
            return false;
        }
        try {
            this._serialPort.setSerialPortParams(baud_rate, this._serialPort.getDataBits(), this._serialPort.getStopBits(), this._serialPort.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

