/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Random;
import moos.operations.utils.ListNodePorts;
import moos.utils.StopWatch;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.PortOccupiedException;

public class PuckTest {
    private Node node = null;
    private FileWriter logFile = null;

    public void execute(String node_url, String port, String log_file) {
        Random randomDelay = new Random();
        int randomDelayTime = 0;
        try {
            this.logFile = new FileWriter(log_file);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        try {
            this.node = (Node)Naming.lookup(node_url);
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("execute() Exception: " + e.getMessage());
            System.exit(1);
        }
        StopWatch scanTimer = new StopWatch();
        this.shutdownPort(port);
        try {
            Date startTime = new Date(System.currentTimeMillis());
            this.logFile.write("File started: " + startTime + "\r\n");
            this.logFile.write("log time\t");
            this.logFile.write("scan status\t");
            this.logFile.write("scan time\t");
            this.logFile.write("random time\t");
            this.logFile.write("service name\t");
            this.logFile.write("service status\t");
            this.logFile.write("comments\r\n");
            this.logFile.flush();
        }
        catch (IOException e) {
            System.err.println("logFile.write() failed");
        }
        while (true) {
            scanTimer.clear();
            scanTimer.start();
            String[] responseScanPort = this.scanPort(port);
            scanTimer.stop();
            randomDelayTime = randomDelay.nextInt(20000) + 30000;
            StopWatch.delay(randomDelayTime);
            String[] responseLisPort = this.listPort(port);
            String responseShutDownPort = this.shutdownPort(port);
            System.out.println("---------------------------");
            System.out.println("scanPort status: " + responseScanPort[0]);
            if (responseScanPort[1] != null) {
                System.out.println("scanPort error: " + responseScanPort[1]);
            }
            System.out.println("scanPort time:  " + scanTimer.read() + " ms");
            System.out.println("delay Time:     " + randomDelayTime + " ms");
            System.out.println("service name:   " + responseLisPort[0]);
            System.out.println("service status: " + responseLisPort[1]);
            if (responseLisPort[2] != null) {
                System.out.println("listPort error: " + responseLisPort[2]);
            }
            try {
                DateFormat dateFormat = DateFormat.getTimeInstance(2);
                this.logFile.write(dateFormat.format(new Date(System.currentTimeMillis())) + "\t");
                this.logFile.write(responseScanPort[0] + "\t");
                this.logFile.write(scanTimer.read() + "\t");
                this.logFile.write(randomDelayTime + "\t");
                this.logFile.write(responseLisPort[0] + "\t");
                this.logFile.write(responseLisPort[1] + "\t");
                if (responseScanPort[1] != null) {
                    this.logFile.write("scanPort error: " + responseScanPort[1]);
                }
                if (responseLisPort[2] != null) {
                    if (responseScanPort[1] != null) {
                        this.logFile.write(", ");
                    }
                    this.logFile.write("listPort errors: " + responseLisPort[2]);
                }
                if (responseShutDownPort != null) {
                    if (responseLisPort[2] != null) {
                        this.logFile.write(", ");
                    }
                    this.logFile.write("shutdownPort errors: " + responseShutDownPort);
                }
                this.logFile.write("\r\n");
                this.logFile.flush();
                continue;
            }
            catch (IOException e) {
                System.err.println("logFile.write() failed");
                continue;
            }
            break;
        }
    }

    private String[] scanPort(String port) {
        String[] response = new String[]{"0", null};
        try {
            this.node.scanPort(port.getBytes());
        }
        catch (DeviceNotFound e) {
            response[1] = "Port " + port + " not found";
            System.err.println(response[1]);
            return response;
        }
        catch (PortOccupiedException e) {
            response[1] = "Service already running on port " + port;
            System.err.println(response[1]);
            return response;
        }
        catch (Exception e) {
            response[1] = "scanPort() Exception: " + e;
            System.err.println(response[1]);
            return response;
        }
        response[0] = "1";
        return response;
    }

    private String[] listPort(String port) {
        String[] response = new String[]{"---", "---", null};
        try {
            Device device = this.node.getDevice(port.getBytes());
            response[0] = new String(device.getName());
            response[1] = ListNodePorts.statusMnem(device.getStatus());
            return response;
        }
        catch (DeviceNotFound e) {
            response[2] = "Device no found on port " + port;
            System.err.println(response[2]);
            return response;
        }
        catch (Exception e) {
            response[2] = "listPort() Exception: " + e.getMessage();
            System.err.println(response[2]);
            return response;
        }
    }

    private String shutdownPort(String port) {
        try {
            this.node.shutdownDeviceService(port.getBytes());
        }
        catch (DeviceNotFound e) {
            String response = "Port " + port + " not found";
            System.err.println(response);
        }
        catch (Exception e) {
            String response = "shutdownPort() Exception: " + e.getMessage();
            System.err.println(response);
            return response;
        }
        return null;
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 3) {
            System.err.println("args.length=" + args.length);
            System.err.println("usage: PuckTest nodeURL portName logFile");
            System.exit(1);
        }
        PuckTest app = new PuckTest();
        app.execute(args[0], args[1], args[2]);
        System.exit(0);
    }
}

