/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Instrument;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.PortNotFound;

public class PrintInstrumentProperties {
    public static void main(String[] args) {
        Node node = null;
        Device[] devices = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length < 2) {
            System.err.println("usage: SampleInstrument nodeURL commPortName");
            System.exit(1);
        }
        String nodeURL = args[0];
        try {
            System.out.println("Looking for node server stub at " + nodeURL);
            node = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(node.getName()) + "\"");
            devices = node.getDevices();
            int i = 0;
            while (i < args.length - 1) {
                try {
                    Device device = node.getDevice(args[i + 1].getBytes());
                    if (device instanceof Instrument) {
                        Instrument instrument = (Instrument)device;
                        System.out.println("\nService properties for port " + args[i + 1] + ":");
                        Vector properties = instrument.getProperties();
                        int j = 0;
                        while (j < properties.size()) {
                            byte[] property = (byte[])properties.elementAt(j);
                            System.out.println(new String(property));
                            ++j;
                        }
                        System.out.println("");
                    } else {
                        System.err.println("Device on port " + args[i + 1] + " is not an Instrument");
                    }
                }
                catch (PortNotFound e) {
                    System.err.println("Port " + args[i + 1] + " not found");
                }
                catch (DeviceNotFound e) {
                    System.err.println("Device not found on port " + args[i + 1]);
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

