/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import moos.deployed.DebugMessage;

public class PowerDemo {
    private static final String MSP_PORT_NAME = "/dev/ttySX15";
    private static final int MSP_BAUD = 9600;
    private static File linuxSuspendFile = null;
    private static FileInputStream linuxSuspendInputStream = null;

    private static void usage() {
        System.out.println("Usage: java moos.operations.PowerDemo <delay in seconds>");
    }

    public static void main(String[] args) {
        SerialPort mspSerialPort;
        int sleepSeconds = 0;
        String serPortName = MSP_PORT_NAME;
        InputStream mspInputStream = null;
        PrintStream mspOutputStream = null;
        char exitChr = '\u0002';
        DebugMessage.setLevel(1L);
        if (args.length == 0) {
            PowerDemo.usage();
            return;
        }
        try {
            sleepSeconds = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            PowerDemo.usage();
            return;
        }
        if (args.length > 1) {
            serPortName = args[1];
        }
        System.err.println("Opening serial port " + serPortName);
        System.setProperty("gnu.io.rxtx.SerialPorts", serPortName);
        try {
            mspSerialPort = PowerDemo.openSerialPort(serPortName, 9600);
        }
        catch (NoSuchPortException e) {
            System.err.println("NoSuchPortException: " + serPortName);
            return;
        }
        catch (Exception e) {
            System.err.println("Exception on opening serial port " + serPortName);
            System.err.println(e.getMessage());
            return;
        }
        try {
            mspInputStream = mspSerialPort.getInputStream();
            mspOutputStream = new PrintStream(mspSerialPort.getOutputStream());
        }
        catch (Exception e) {
            System.err.println("Exception on opening streams for " + serPortName);
            System.err.println(e.getMessage());
            return;
        }
        System.err.println("Setting MSP430 alarm  for " + sleepSeconds + " seconds");
        mspOutputStream.println();
        mspOutputStream.println("set alarm " + sleepSeconds);
        mspOutputStream.print(exitChr);
        mspOutputStream.println("x");
        mspOutputStream.flush();
        System.err.println("Opening linux /proc file");
        if (!PowerDemo.setupLinuxSleepProcFile()) {
            System.err.println("Failed to open /proc/sys/pm/suspend");
            return;
        }
        System.err.println("Sleeping... ");
        System.err.println();
        System.err.flush();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        PowerDemo.doSuspend();
        System.err.println();
        System.err.println("Awake!");
        System.err.println();
    }

    static SerialPort openSerialPort(String devicePortName, int baud) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, Exception {
        DebugMessage.println("Get port identifier for \"" + devicePortName + "\"...");
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)devicePortName);
        DebugMessage.println("Got port identifier!");
        if (portId.getPortType() != 1) {
            throw new Exception("Port " + devicePortName + " is not a serial port.");
        }
        DebugMessage.println("open ze serial port..." + devicePortName);
        SerialPort serialPort = (SerialPort)portId.open(devicePortName, 1000);
        DebugMessage.println("set port params...");
        serialPort.setSerialPortParams(baud, 8, 1, 0);
        return serialPort;
    }

    private static boolean setupLinuxSleepProcFile() {
        boolean retVal = false;
        try {
            linuxSuspendFile = new File("/proc/sys/pm/suspend");
            if (linuxSuspendFile.exists()) {
                linuxSuspendInputStream = new FileInputStream(linuxSuspendFile);
                retVal = true;
            }
        }
        catch (Exception e) {
            System.err.println("exception on suspend file open");
            System.err.println(e.getMessage());
        }
        return retVal;
    }

    private static void doSuspend() {
        if (linuxSuspendInputStream != null) {
            try {
                linuxSuspendInputStream.read();
            }
            catch (IOException ioe) {
                System.err.println("doSuspend: IOException on read");
                System.err.println(ioe.getMessage());
            }
        }
    }
}

