/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.PowerSwitch;

public class ListNodeSwitches {
    static final int SWITCHNAME_WIDTH = 18;
    static final int ID_WIDTH = 20;

    void appendField(StringBuffer line, String fieldValue, int fieldWidth) {
        line.append(fieldValue);
        int nBlanks = fieldWidth - fieldValue.length();
        int i = 0;
        while (i < nBlanks) {
            line.append(' ');
            ++i;
        }
    }

    public String header() {
        StringBuffer lineBuffer = new StringBuffer(90);
        this.appendField(lineBuffer, "Switch name", 18);
        this.appendField(lineBuffer, "Attached ISI-ID", 20);
        StringBuffer lineBuffer2 = new StringBuffer(90);
        this.appendField(lineBuffer2, "---------", 18);
        this.appendField(lineBuffer2, "------", 20);
        return new String(lineBuffer + "\n" + lineBuffer2);
    }

    public StringBuffer listPort(Node node, PowerSwitch powerSwitch) throws RemoteException {
        StringBuffer lineBuffer = new StringBuffer(90);
        String switchName = new String(powerSwitch.getName());
        this.appendField(lineBuffer, switchName, 18);
        try {
            this.appendField(lineBuffer, Long.toString(powerSwitch.getSwitchedDeviceID()), 20);
        }
        catch (DeviceNotFound e) {
            this.appendField(lineBuffer, "-", 20);
        }
        return lineBuffer;
    }

    public static void main(String[] args) {
        ListNodeSwitches lister = new ListNodeSwitches();
        Node nodeService = null;
        PowerSwitch[] powerSwitches = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length != 1) {
            System.err.println("Usage: nodeURL");
            System.exit(1);
        }
        String nodeURL = args[0];
        try {
            System.out.println("Looking for node service at " + nodeURL);
            nodeService = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + nodeURL + "\"");
            System.exit(1);
        }
        try {
            powerSwitches = nodeService.getPowerSwitches();
            System.out.println("Node has " + powerSwitches.length + " power switches\n");
            System.out.println(lister.header());
            int i = 0;
            while (i < powerSwitches.length) {
                System.out.println(lister.listPort(nodeService, powerSwitches[i]));
                ++i;
            }
            System.out.println("");
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Got some exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

