/*
 * Decompiled with CFR 0.152.
 */
package moos.operations.utils;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.mbari.isi.interfaces.Device;
import org.mbari.isi.interfaces.DeviceNotFound;
import org.mbari.isi.interfaces.Node;
import org.mbari.isi.interfaces.Port;

public class ListNodePorts {
    static final int PORTNAME_WIDTH = 18;
    static final int SERVICENAME_WIDTH = 43;
    static final int SERVICESTATUS_WIDTH = 10;
    static final int ID_WIDTH = 8;

    public static String statusMnem(int status) {
        switch (status) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "INIT";
            }
            case 3: {
                return "SHUTDOWN";
            }
            case 4: {
                return "SUSPEND";
            }
            case 5: {
                return "SAMPLING";
            }
        }
        return "UNKNOWN!";
    }

    void appendField(StringBuffer line, String fieldValue, int fieldWidth) {
        line.append(fieldValue);
        int nBlanks = fieldWidth - fieldValue.length();
        int i = 0;
        while (i < nBlanks) {
            line.append(' ');
            ++i;
        }
    }

    public String header() {
        StringBuffer lineBuffer = new StringBuffer(90);
        this.appendField(lineBuffer, "Port name", 18);
        this.appendField(lineBuffer, "Service", 43);
        this.appendField(lineBuffer, "ISI-ID", 8);
        this.appendField(lineBuffer, "Status", 10);
        StringBuffer lineBuffer2 = new StringBuffer(90);
        this.appendField(lineBuffer2, "---------", 18);
        this.appendField(lineBuffer2, "-------", 43);
        this.appendField(lineBuffer2, "------", 8);
        this.appendField(lineBuffer2, "------", 10);
        return new String(lineBuffer + "\n" + lineBuffer2);
    }

    public StringBuffer listPort(Node node, Port port) throws RemoteException {
        StringBuffer lineBuffer = new StringBuffer(90);
        String portName = new String(port.getName());
        this.appendField(lineBuffer, portName, 18);
        try {
            String serviceName = new String(port.getServiceMnemonic());
            this.appendField(lineBuffer, serviceName, 43);
            this.appendField(lineBuffer, Long.toString(port.getDeviceID()), 8);
            Device device = node.getDevice(port.getDeviceID());
            this.appendField(lineBuffer, ListNodePorts.statusMnem(device.getStatus()), 10);
        }
        catch (DeviceNotFound e) {
            this.appendField(lineBuffer, "-", 43);
            this.appendField(lineBuffer, "-", 8);
            this.appendField(lineBuffer, "-", 10);
        }
        return lineBuffer;
    }

    public static void main(String[] args) {
        ListNodePorts lister = new ListNodePorts();
        Node nodeService = null;
        Port[] ports = null;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        if (args.length != 1) {
            System.err.println("Usage: nodeURL");
            System.exit(1);
        }
        String nodeURL = args[0];
        try {
            System.out.println("Looking for node service at " + nodeURL);
            nodeService = (Node)Naming.lookup(nodeURL);
            System.out.println("Got proxy for node service \"" + new String(nodeService.getName()) + "\"");
        }
        catch (Exception e) {
            System.err.println("Caught exception: " + e.getMessage());
            System.err.println("Couldn't get service at \"" + nodeURL + "\"");
            System.exit(1);
        }
        try {
            ports = nodeService.getPorts();
            System.out.println("Node has " + ports.length + " ports\n");
            System.out.println(lister.header());
            int i = 0;
            while (i < ports.length) {
                System.out.println(lister.listPort(nodeService, ports[i]));
                ++i;
            }
            System.out.println("");
        }
        catch (RemoteException e) {
            System.err.println("RemoteException: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Got some exception: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

